/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Header file for the eoslib namespace

Description:

This file is a wrapper for all errors.

*****************************************************************************/


#ifndef EOSLIB_ERR
#define EOSLIB_ERR

#include <stdexcept>

#define DEF_EXCEPTION(NAME) \
    class NAME: public std::runtime_error { \
        public: \
            NAME (std::string msg): std::runtime_error(msg) {} };

#define STRINGIFY(x) #x
#define TOSTRING(x) STRINGIFY(x)

#endif

