/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to the processing of a file.


*****************************************************************************/

#include <cassert>
#include "eoslib_file.h"
#include "eoslib_group.h"
#include "eoslib_exception.h"

// list all children of eosfile class
// Only EOS files are handled in this class now.
#include "eos2_file.h"
//#include "ncml_file.h"
#include "filterset.h"

namespace eoslib
{
extern filter_set g_filter_set_cf;
//extern FILTER_SET(cf);

extern filter_set g_filter_set_ncml;
//extern FILTER_SET(ncml);

//extern FILTER_SET(special);

extern filter_set g_filter_set_cf_checker;
//extern FILTER_SET(cf_checker);

group* open(const char *filename, open_mode_t mode)
{
    group* root = NULL;


/**
 * This macro is NOT complete.
 * I intended to call open functions of each module one by one
 * until one success.
 *
 * This should be written correctly when
 * adding the second module.
 */
// NcML processing has not been implemented for this release. The future release may provide it. 
/*
#define HANDLE(func) \
    try { \
        root = func(filename); \
        if(root) \
        { \
            if(mode && CF) \
            { \
                APPLY_FILTER_SET(ncml, root); \
                APPLY_FILTER_SET(cf, root); \
            } \
            int c = APPLY_FILTER_SET(cf_checker, root); \
            if(c==0) \
                return root; \
        } \
    } \
    catch (CannotOpenFileException e) \
    { } 

    HANDLE(eos2_fopen);
    //HANDLE(ncml_fopen);

#undef HANDLE
*/

// For this release, the filtering modifies the opening file and  make it comply with CF conventions. In the future release, filtering of other types may be provided. 
#define HANDLE(func) \
    try { \
        root = func(filename); \
        if(root) \
        { \
            if(mode && CF) \
            { \
                APPLY_FILTER_SET(cf, root); \
            } \
            int c = APPLY_FILTER_SET(cf_checker, root); \
            if(c==0) \
                return root; \
        } \
    } \
    catch (CannotOpenFileException e) \
    { }

    // HANDLE(eos2_fopen);

#undef HANDLE

    try {
        root = eos2_fopen(filename);
        if(root)
        {
            if(mode && CF)
            {
                // Just apply filters listed in flt_cf.cpp
                _APPLY_FILTER_SET(g_filter_set_cf, root);
                //APPLY_FILTER_SET(cf, root);
            }

            // Only check if the file has children groups.
            int c = _APPLY_FILTER_SET(g_filter_set_cf_checker, root);
            //int c = APPLY_FILTER_SET(cf_checker, root);
            if(c==0)
            return root;
        } // end of if(root)
    } 
    catch(CannotOpenFileException &e) 
    {
        std::cerr<<"Cannot open the file "<<std::endl;
    }
    return NULL;
} //end of group* open

} // namespace

