/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the eoslib name space

Description:

This header includes the file open function and the declaration of a struct that contains the file info. 

*****************************************************************************/


#ifndef EOSLIB_FILE_H
#define EOSLIB_FILE_H

//#include <gtest/gtest.h>
#include <vector>
#include <string>

#include "eoslib_group.h"
#include "eoslib_rc.h"

namespace eoslib
{

typedef enum {
    NONE = 0x00000000,
    CF = 0x00000001,
} open_mode_t;

//! Open a file
/**
 * This function opens a supported HDF-EOS2 file and 
 * returns a pointer to the root group.
 *
 * \param mode If mode is CF, the returned data structure
 * 				conforms to the CF-constraints.
 * 				If it is NONE, no CF-related processing is done.
 *            Note: Even if the mode is NONE, the conversion toolkit still follows CF to 
 *                  convert a non-HDFEOS2 HDF4 file. Unfortuately the implementation 
 *                  doesn't follow the design.
 *                
 */
group* open(const char *filename, open_mode_t mode);

//! File-related information
/**
 *  This struct maintains file-related information.
 */
struct file_info: refcnt
{
    public:
        file_info(): refcnt() {}
        ~file_info() {}

        //! File name
        std::string m_filename;
};
} // namespace
#endif
