/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the method stubs related to the basic processing of 
a NcML file.

*****************************************************************************/

#include <iostream>
#include <cassert>
#include <fstream>
#include <string>
#include <map>

#include <hdf.h>
#include <HdfEosDef.h>

#include "eos2_defs.h"
#include "eoslib_exception.h"
#include "eoslib_ncml_file.h"
#include "mem_attr.h"
#include "mem_var.h"
#include "misc_util.h"

namespace eoslib
{

ncml_file::ncml_file (const char *filename)
{
    fopen(filename);
}

ncml_file::~ncml_file()
{
}

// The implementation of this function will be provided in the future release.
void ncml_file::fopen(const char *filename)
{
    attrs_to_be_renamed.insert(std::pair<std::string, std::string>("add_offset_err", "add_offset_error"));
	
// Leave the following code for this release. KY 2013-05-30
#if 0
/*
    std::ifstream f;
    std::string buf;

    ncml_file *nf = new ncml_file(filename);
    f.open(filename);
    if(!f.is_open())
        goto err_out;

    while(!f.eof())
    {
        getline(f, buf);
        //std::cout << buf << std::endl;

        std::istringstream is(buf);
        std::string cmd;
        is >> cmd;
        //std::cout << cmd << std::endl;
        if(cmd == "LOAD")
        {
            std::string filename;
            is >> filename;
            if(nf->_load(filename))
            goto err_out;
        }
        else if(cmd == "RENAMEVAR")
        {
            std::string varpath, newname;
            is >> varpath >> newname;
            if(nf->_rename_var(varpath, newname))
                goto err_out;
        }
        else if(cmd == "REMOVEVAR")
        {
           std::string varpath;
           is >> varpath;
           if(nf->_remove_var(varpath))
               goto err_out;
        }
        else if(cmd == "NEWATTR")
        {
            // XXX. Note that this code cannot handle quoted strings.
            std::string varpath, attrname, attrtype, attrvalue;
            is >> varpath >> attrname >> attrtype >> attrvalue;
            if(nf->_new_attr(varpath, attrname, attrtype, attrvalue))
                goto err_out;
        }
        else if(cmd == "NEWVAR")
        {
            // XXX/ Note that we are not handling two-dim var
            std::string varpath, varname, vartype, varvalue;
            int rank = 0;
            std::vector<int> dims;

            is >> varpath >> varname >> vartype >> rank;
            for(int i=0; i<rank; i++)
            {
                int d = 0;
                is >> d;
                dims.push_back(d);
            }
			
            getline(is, varvalue);
            //std::cout << " **** [ " << varvalue << " ]" << std::endl;
            if(nf->_new_var(varpath, varname, vartype, dims, varvalue))
                goto err_out;	
        }
        else if(cmd == "LOADGROUP")
        {
            std::string filename, grouppath, newgrouppath;
            is >> filename >> grouppath >> newgrouppath;
            if(nf->_load_group(filename, grouppath, newgrouppath))
               goto err_out;
        }
        else if(cmd == "")
        {
        }
        else
        {
            throw CannotOpenFileException(filename);
        }
    } //end of while(!f.eof())

    f.close();
    return nf;

err_out:
	delete nf;
	return NULL;
*/
#endif
}

// The implementation of this function will be provided in the future release.
int ncml_file::_load(const std::string& filename)
{
#if 0
/*
    if(m_root_group == NULL)
    {
        m_root_group = eoslib::open(filename.c_str(), NONE);
        if(m_root_group) 
        {
            //m_root_group->dump_r(0);
            return 0;
        }
        else
        {
            // error. open failure
            return -1;
        }
    } 
    else 
    {
        // error. load twice
        return -1;
    } // end  of if(m_root_group == NULL)
*/
#endif
	return 0;
}

// The implementation of this function will be provided in the future release.
int ncml_file::_rename_var(const std::string& varpath, const std::string& newname)
{
#if 0
/*
    if(m_root_group)
    {
        var* v = m_root_group->get_var_by_path(varpath);
        v->rename(newname);
        return 0;
    }
    else
        return -1;
*/
#endif
	return 0;
}

// The implementation of this function will be provided in the future release.
int ncml_file::_remove_var(const std::string& varpath)
{
/*
    if(m_root_group)
    {
        group *g;
        var* v = m_root_group->get_var_by_path(varpath, &g);
        g->remove_var(v);
        return 0;
    }
    else
        return -1;
*/
	return 0;
}

// The implementation of this function will be provided in the future release.
int ncml_file::_new_attr(
    const std::string& varpath, 
    const std::string& attrname, 
    const std::string& attrtype, 
    const std::string& attrvalue)
{
/*
    if(m_root_group)
    {
        var* v = m_root_group->get_var_by_path(varpath);

        mem_attr*a = new mem_attr(attrname);
		
        if(attrtype == "string") 
            a->set_value(DFNT_CHAR8, attrvalue.size() + 1, attrvalue.c_str());
        else
            assert(0);
        v->add_attr(static_cast<attr*>(a));

        //v->dump_r(0);
        return 0;
    }
    else
        return -1;
*/
	return 0;
}

// The implementation of this function will be provided in the future release.
int ncml_file::_new_var(
    const std::string& varpath, 
    const std::string& varname, 
    const std::string& vartype, 
    const std::vector<int>& dims,
    const std::string& varvalues)
{
#if 0
/*
    if(m_root_group)
    {
        group *g = NULL;
        var* v = m_root_group->get_var_by_path(varpath, &g);
        if(v == NULL)
        {
            std::list<dim*> dv;

            int tot_elements = 1;
            for(int i=0; i<dims.size(); i++)
            {
                std::ostringstream os;
                os << varname << "_dim" << i;

                tot_elements *= dims[i];
                dim *d = new dim(os.str(), dims[i]);
                dv.push_back(d);
                d->inc();
            } // end of for

            mem_var *v = new mem_var(varname);
            v->inc();
            value_type_t type;

#define HANDLE(S, T, N) \
    if(vartype == S) \
    { \
        type = T; \
        std::vector<N> buf; \
        buf.reserve(tot_elements); \
        std::istringstream is(varvalues); \
        for(int i=0; i<tot_elements; i++) \
        { \
            N val; \
            is >> val; \
            buf.push_back(val); \
        } \
        v->set(type, dv, (const void*) &buf[0]); \
    }

            HANDLE("char8", DFNT_CHAR8, char8)
            else HANDLE("uchar8", DFNT_UCHAR8, uchar8)
            else HANDLE("int8", DFNT_INT8, int8)
            else HANDLE("uint8", DFNT_UINT8, uint8)
            else HANDLE("int16", DFNT_INT16, int16)
            else HANDLE("uint16", DFNT_UINT16, uint16)
            else HANDLE("int32", DFNT_INT32, int32)
            else HANDLE("uint32", DFNT_UINT32, uint32)
            else HANDLE("float32", DFNT_FLOAT32, float32)
            else HANDLE("float64", DFNT_FLOAT64, float64)
#undef HANDLE
            g->m_dims.splice(g->m_dims.end(), dv);
            g->m_vars.push_back(v);
        }
        else
        {
            // Variable is existing
            assert(0);
            return -1;
        } // end of  if(v == NULL)
        return 0;
    } // end of if(m_root_group)
    else
        return -1;
*/
#endif
	return 0;
}

// The implementation of this function will be provided in the future release.
int ncml_file::_load_group(
    const std::string& filename,
    const std::string& grouppath,
    const std::string& newgrouppath)
{
#if 0
/*
    if(m_root_group)
    {
        group *root2 = open(filename.c_str(), NONE);
        if(!root2)
            return -1;
        group *src, *dst;
        group *item = root2->get_group_by_path(grouppath, &src);
        assert(item);
        group *item2 = m_root_group->get_group_by_path(newgrouppath, &dst);
        assert(item2 == NULL);
        move_group(src, dst, item);

        // rename
        std::vector<std::string> tokens;
        util_split_str(newgrouppath, "/", &tokens);
        assert(tokens.size() > 0);
        item->rename(*(tokens.rbegin()));

        delete root2;

        return 0;
    } // end of if
    else
        return -1;
*/
#endif
	return 0;
}
}	// namespace
