/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the eoslib namespace

Description:

This file includes a basic definition of a NcML file and and includes related method 
declarations.

Currently NcML module is not used at all.


*****************************************************************************/

#ifndef EOSLIB_NCML_FILE_H
#define EOSLIB_NCML_FILE_H

//#include <gtest/gtest.h>
#include "eoslib_file.h"

namespace eoslib
{

class ncml_file
{
    public:
        ncml_file(const char *filename);
        ~ncml_file();
        void fopen(const char *filename);

    private:
        int _load(const std::string& filename);
        int _rename_var(const std::string& varpath, const std::string& newname);
        int _remove_var(const std::string& varpath);
        int _new_attr(
            const std::string& varpath, 
            const std::string& attrname, 
            const std::string& attrtype, 
            const std::string& attrvalue);
        int _new_var(
            const std::string& varpath, 
            const std::string& varname, 
            const std::string& vartype, 
            const std::vector<int>& dims,
            const std::string& varvalues);
        int _load_group(
            const std::string& filename,
            const std::string& grouppath,
            const std::string& newgrouppath);

    public:
        std::map<std::string, std::string> attrs_to_be_renamed;
};
} // namespace

#endif

