/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to the processing of renaming 
and  basic reference counting of dynamically allocated objects.

*****************************************************************************/

#include "eoslib_rc.h"
#include <cassert>
#include <iostream>

refcnt::refcnt(): m_refcnt(0)
{
}

refcnt::~refcnt()
{
}

void refcnt::inc(const renamable* owner) 
{
#ifdef DEBUG
    if(m_owners.find(const_cast<renamable*>(owner)) == m_owners.end())
        m_owners.insert(const_cast<renamable*>(owner));
    else
        assert(0);
#endif
    //std::cout << owner->get_name() << " inc() from " << m_refcnt << std::endl;
    //if(m_name == "m_hgdf")
    //{
    //    std::cout << "##" << std::endl;
    //}
    std::cout.flush();
    m_refcnt++;
}

void refcnt::dec(const renamable* owner) 
{
#ifdef DEBUG
    std::set<renamable*>::iterator it;
    it = m_owners.find(const_cast<renamable*>(owner));
    if(it != m_owners.end())
        m_owners.erase(it);
    else
        assert(0);
#endif
    if((--m_refcnt)==0) 
    {
        //std::cout << "DBG: refcnt::dec" << std::endl;
        std::cout.flush();

        delete this;
    }

    //dump_owners();
}

unsigned int refcnt::get_refcnt() const 
{
    return m_refcnt;
}

// For internal_testing only.
#ifdef DEBUG
void refcnt::dump_owners() const
{
    std::set<renamable*>::const_iterator it;
    for(it = m_owners.begin(); it != m_owners.end(); it++)
    {
        std::cout << (*it)->get_name() << " ";
    }
    std::cout << std::endl;
}
#endif
