/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes getter methods for HDF4 data types.

*****************************************************************************/

#include "eoslib_types.h"
#include <cassert>
#include <stdexcept>
#include "eoslib_err.h"

namespace eoslib
{

size_t get_type_size(value_type_t type)
{
    switch(type)
    {
#define HANDLE(type) \
    case DFNT_##type: \
        return SIZE_##type; 

        HANDLE(CHAR8);
        HANDLE(INT8);
        HANDLE(INT16);
        HANDLE(INT32);
        HANDLE(UCHAR8);
        HANDLE(UINT8);
        HANDLE(UINT16);
        HANDLE(UINT32);
        HANDLE(FLOAT32);
        HANDLE(FLOAT64);

#undef HANDLE
        default:
            throw std::range_error("Unknown type(" __FILE__ ":" TOSTRING(__LINE__)")" );
    } // end of switch
}

std::string get_type_str(value_type_t type)
{
    switch(type)
    {
#define HANDLE(type) \
    case DFNT_##type: \
        return #type; 

        HANDLE(CHAR8);
        HANDLE(INT8);
        HANDLE(INT16);
        HANDLE(INT32);
        HANDLE(UCHAR8);
        HANDLE(UINT8);
        HANDLE(UINT16);
        HANDLE(UINT32);
        HANDLE(FLOAT32);
        HANDLE(FLOAT64);

#undef HANDLE
        default:
            throw std::range_error("Unknown type(" __FILE__ ":" TOSTRING(__LINE__)")" );
    };
}

} // namespace
