/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the eoslib namespace

Description:

This file includes misc. functions related to the handling of the data type.


*****************************************************************************/

#ifndef EOSLIB_TYPES_H
#define EOSLIB_TYPES_H

#include <mfhdf.h>
#include <string>

namespace eoslib
{
    /**
     * HDF4 data type
     */
    typedef int32 value_type_t;

    /**
     * This function returns the storage size
     * of the given data type.
     */
    size_t get_type_size(value_type_t type);

    /**
     * This function returns the string representation of
     * the type name.
     */
    std::string get_type_str(value_type_t type);
} // namespace

#endif
