/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to the processing of a filter 
and a filter set.


*****************************************************************************/

#include "filterset.h"

namespace eoslib {

filter_set::filter_set() { }
filter_set::~filter_set()
{
    while(!m_filters.empty())
    {
        delete m_filters.begin()->second;
        m_filters.erase(m_filters.begin());
    }
}
void filter_set::add(std::string name, int priority, modifier_t m, void *arg)
{
    filter *f = new filter;
    f->m_name = name;
    f->m_modifier = m;
    f->m_arg = arg;
    m_filters.insert(std::make_pair(priority, f));
}
int filter_set::apply(group *g) const
{
    std::set<std::pair<int, filter*> >::const_iterator it;
    for(it = m_filters.begin(); it != m_filters.end(); it++)
    {
        //std::cout << "Filter: " << it->second->m_name << std::endl;
        //int priority = it->first;
        //std::cout <<"\tpriority=" << priority << std::endl;
        filter* f = it->second;
        int r = f->m_modifier(g, f->m_arg);
        if(r != 0)
            return r;
    }
    return 0;
}

} // namespace
