/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the HDF4 namespace

Description:

This file includes a definition of an HDF4 attribute class. It also includes related method
declarations.

*****************************************************************************/

#ifndef HDF4_ATTR_H
#define HDF4_ATTR_H

#include <sstream>
#include <iostream>
#include "eoslib_defs.h"

using namespace eoslib;

namespace hdf4
{
class hdf4_attr: public attr
{
    public:
        // Default constructor.
        hdf4_attr();

        // Paramenter 1: attribute name
        // Paramenter 2: attribute data type
        // Paramenter 3: attribute count
        // Paramenter 4: attribute data value
        hdf4_attr(std::string, int32, int, std::vector<char>);
        // Default destructor.
        ~hdf4_attr();

        // Get attribute name.
        const std::string & get_name () const
        {
            return this->m_name;
        }
       
        // Get data type.
        inline value_type_t get_type() const
        {
            return type;
        }

        // Get a count of the number of elements.
        inline unsigned  int get_num_elements() const
        {
            return this->count;
        }

        // Get a count of the number of bytes of data.
        inline unsigned int get_size() const
        {
            return value.size();
        }
 
        // Get attribute value.
        const std::vector < char >& get_value () const
        {
            return this->value;
        }
	
        // Get attribute value and store the value in vector user provides.
        void get_value(std::vector<char> *pbuf) const
        {
            pbuf->resize(value.size());
            for(size_t k=0; k<value.size(); k++)
                (*pbuf)[k] = value[k];
        }
	
        // Get data value.
        inline void get_value(void *buf) const
        {
            buf =  (void*)&value[0];
        }

        inline attr *clone() const
        {
            return NULL;
        }

        inline bool same_obj_test(attr *) const
        {
            return true;
        }

        // Get the string representation of attribute value.
        const std::string get_str_value() const;

        //virtual value_type_t get_type() const;
        //virtual unsigned int get_size() const;
        //virtual void get_value(void *buf) const;
        //virtual attr *clone() const;
        //virtual bool same_obj_test(attr *) const;
        //virtual unsigned int get_num_elements() const;

    protected:
        // Data type.
        int32 type;
	
        // The number of elements.
        int32 count;
	
        // Store attribute value.
        std::vector < char >value;

        friend class hdf4_file;
        friend class hdf4_var_vdfield;
        friend class VDATA;
};
} //end of namespace

#endif

