/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related of the processing of an HDF4 
dimension.

*****************************************************************************/

#include "hdf4_dim.h"

namespace hdf4 {
	
hdf4_dim::hdf4_dim(const std::string& hdf4dimname, const std::string& hdf4dim_origname, unsigned int size, int32 type):dim(NULL, hdf4dimname, size), origname(hdf4dim_origname), dimsize(size), dimtype(type){}

hdf4_dim::~hdf4_dim(){}

dim* hdf4_dim::clone(group *g) const 
{
    return NULL;
}
} //end of namesapce

