/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Header file for the HDF4 namespace

Description:

This file is a definition of an HDF4 dimension class(hdf4_dim).

*****************************************************************************/


#ifndef HDF4_DIM_H
#define HDF4_DIM_H

#include "eoslib_defs.h"

using namespace eoslib;

namespace hdf4 {

class hdf4_dim : public dim
{
    public:
        // Parameter 1: dimension name
        // Parameter 2: original dimension name
        // Parameter 3: dimension size
        // Parameter 4: dimension type
        hdf4_dim(const std::string& hdf4dimname,const std::string& hdf4dim_origname,
             unsigned int size,
             int32 type);

        // Default destructor.
        ~hdf4_dim();

        // Get dimension name.
        const std::string & get_name () const
        {
            return this->m_name;
        }

        // Set dimension orig. name.
        const std::string & get_orig_name () const
        {
            return this->origname;
        }


        // Set dimension size.
        void set_size(int32 s) 
        {
            dimsize = s;
        }	

        // Get dimension size.
        int32 get_size () const
        {
            return this->dimsize;
        }

        // Get dimension type.
        int32 get_type () const
        {
            return dimtype;
        }

        virtual dim *clone(group *g) const;	

    protected:
        // dimsize: dimension size.
        int32 dimsize;
        // dimtype: dimension type.
        int32 dimtype;

        // Original dimension name(may have characters not allowed by CF)
        std::string origname;
};

} //end of namespace

#endif
