/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to the processing of a wrapper for a method and a filter queue.


*****************************************************************************/

#include "hdf4_filterqueue.h"

namespace hdf4 {

filterqueue::filterqueue() {};

filterqueue::~filterqueue() {}

// Add a method wrapper to queue.
void filterqueue::add(method m)
{
    wrapper *w = new wrapper();
    w->m_method = m;
    m_queue.push(w);
}

// Execute all methods in queue. The exection order is First-In-First-Out.  
void filterqueue::apply(bool use_filter)
{
    while (!m_queue.empty())
    {
        if(true == use_filter)
            m_queue.front()->m_method();
        delete m_queue.front();
        m_queue.pop();
    }
}

} //end of namespace
