/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for HDF4 namespace.

Description:

This file includes declarations of a "method" wrapper struct and a filter queue.


*****************************************************************************/

#ifndef FILTER_QUEUE_H
#define FILTER_QUEUE_H

#include <queue>

namespace hdf4 {

typedef void(*method)();

struct wrapper {
    method m_method;
};

class filterqueue
{
    public:
        filterqueue();
        ~filterqueue();
        void add(method m);
        void apply(bool );
        //void release_unused_memory();

    private:
        std::queue<wrapper*> m_queue;
};

#define FILTERQUEUE() filterqueue m_filterqueue;

#define ADD_METHOD(mod) \
    class method_##mod { \
        public: \
            method_##mod() { \
                m_filterqueue.add(mod); \
            } \
    }; \
    method_##mod g_method_##mod;

}//end of namespace

#endif
