/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implemetation related to the processing of a filter and a filter set.


*****************************************************************************/

#include "hdf4_filterset.h"
namespace hdf4 {

filterset::filterset() {};
filterset::~filterset()
{
    std::set<filter*>::iterator it;
    for(it=myfilters.begin(); it!=myfilters.end(); it++)
        delete (*it);
}

// Add a method wrapper to set.
void filterset::add(modifier m)
{
    filter *f = new filter;
    f->mymodifier = m;
    myfilters.insert(f);
}

// Execute all methods in set.
void filterset::apply()
{
    std::set<filter*>::iterator it;
    for(it=myfilters.begin(); it!=myfilters.end(); it++)
        (*it)->mymodifier();
}

} //end of namespace
