/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for HDF4 namespace

Description:

This file includes declarations of a filter struct and a filterset class.


*****************************************************************************/


#ifndef FILTERSET_H 
#define FILTERSET_H

#include <set>

namespace hdf4 {

typedef void(*modifier)();

struct filter {
    modifier mymodifier;
};

class filterset
{
    public: 
        filterset();
        ~filterset();
        void add(modifier m);
        void apply();

    private:
        std::set<filter*> myfilters;
};

#define FILTERSET() filterset m_filterset;

#define ADD_NCML_FILTER(mod) \
    class filter_##mod { \
        public: \
            filter_##mod() { \
                m_filterset.add(mod); \
            } \
    }; \
    filter_##mod g_filter_##mod;	
			
} //end of namespace

#endif
