/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the method stubs related to the processing of a NcML file
specific to HDF4.


*****************************************************************************/

#include <iostream>
#include <string>
#include <map>
#include "eoslib_ncml_file.h"
#include "hdf4_filterset.h"
#include "hdf4_file.h"

extern hdf4::hdf4_file *file;
extern eoslib::ncml_file *ncmlfile;

namespace hdf4 {

// The implementation of this function will be provided in the future release.
void prepare_ncml()
{
    std::map<std::string, std::string>::const_iterator it;
    it = (ncmlfile->attrs_to_be_renamed).begin();
    std::cout << "[hdf4_ncml]" << (*it).first << "\t" << (*it).second << std::endl;
}

// The implementation of this function will be provided in the future release.
void modify_dim()
{
    std::cout << "[hdf4_ncml]" << "add dimension name and length pair" << std::endl; 
}

// The implementation of this function will be provided in the future release.
void change_attr_value()
{
    std::cout << "[hdf4_ncml]" << "change attribute's value" << std::endl;
}

// The implementation of this function will be provided in the future release.
void add_attr()
{
    std::cout << "[hdf4_ncml]" << "add attributes" << std::endl;
}

// The implementation of this function will be provided in the future release.
void rename_attr()
{
    std::cout << "[hdf4_ncml" << "rename attributes" << std::endl;
}

// The implementation of this function will be provided in the future release.
void change_var()
{
    std::cout << "[hdf4_ncml" << "change variable's attribute" << std::endl;
}

// The implementation of this function will be provided in the future release.
void add_var()
{
    std::cout << "[hdf4_ncml]" << "add variables" << std::endl;
}

// The implementation of this function will be provided in the future release.
void rename_var()
{
    std::cout << "[hdf4_ncml]" << "rename variable names" << std::endl;
}

filterset m_filterset;
//FILTERSET();

class filter_ncml
{
    public:
    filter_ncml()
    {
        m_filterset.add(prepare_ncml);
        m_filterset.add(modify_dim);
        m_filterset.add(change_attr_value);
        m_filterset.add(add_attr);
        m_filterset.add(rename_attr);
        m_filterset.add(change_var);
        m_filterset.add(add_var);
        m_filterset.add(rename_var);		
    } // end of constructor
};
filter_ncml fncml;

//ADD_NCML_FILTER(prepare_ncml);
//ADD_NCML_FILTER(modify_dim);
//ADD_NCML_FILTER(change_attr_value);
//ADD_NCML_FILTER(add_attr);
//ADD_NCML_FILTER(rename_attr);
//ADD_NCML_FILTER(change_var);
//ADD_NCML_FILTER(add_var);
//ADD_NCML_FILTER(rename_var);

} //end of namespace
