/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to processing a collection
of HDF4 Scientific Datasets.

*****************************************************************************/

#include "hdf4_sd.h"

namespace hdf4 {

SD::SD () {}
SD::~SD() 
{
    for(std::vector<hdf4_attr *>::const_iterator i=attrs.begin(); i!=attrs.end(); i++)
        delete *i;
    for(std::vector<hdf4_var_sdfield *>::const_iterator i=sdfields.begin(); i!=sdfields.end(); i++)
        delete *i;
}

} //end of namespace
