/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the HDF4 namespace

Description:

This file contains the information of the HDF4 Scientific Datasets(SD) class.  

*****************************************************************************/

#ifndef HDF4_SD_H
#define HDF4_SD_H

#include <string>
#include <vector>
#include <map>
#include <set>

#include "hdf4_sds.h"
#include "hdf4_attr.h"

namespace hdf4 {

using namespace eoslib;

class SD
{
    public:
        // Public interface to obtain information of all SDS vectors(objects).
        const std::vector < hdf4_var_sdfield * >&get_fields () const
        {
            return this->sdfields;
        }

        // Public interface to obtain the SD(file) attributes.
        const std::vector < hdf4_attr * >&get_attrs () const
        {
            return this->attrs;
        }

        ~SD ();
        SD();

    public:
        // SDS objects stored in vectors.
        std::vector < hdf4_var_sdfield * >sdfields;
 
        // SD attributes stored in vector.
        std::vector < hdf4_attr * >attrs;

        //SDS reference number to index map, use to quickly obtain the SDS id.
        std::map < int32, int > refindexlist;

        //Unique dimension name to its size map, may be replaced in the current implementation. Still leave it here for potential fakeDim handling in the future.
        std::map < std::string, int32 > n1dimnamelist;

        // Original dimension name to corrected dimension name map.
        std::map < std::string, std::string > n2dimnamelist;

        // Full dimension name list set.
        std::set < std::string > fulldimnamelist;

        // This set stores non-missing coordinate variable dimension names. Many third dimensions of HDF4 files have to be treated as missing coordinate variables. But latitude and longitude's corresponding dimensions are normally provided in the file. So this set is used to exclude these dimensions when creating the corresponding missing fields.
        std::set < std::string > nonmisscvdimnamelist;

        // dimension name to coordinate variable name list: the key list to generate CF "coordinates" attributes.
        std::map < std::string, std::string > dimcvarlist;

        friend class hdf4_file;
};

} //end of namespace

#endif
