/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the HDF4 namespace

Description:

This file contains constants used to handle HDF4 files.  



*****************************************************************************/


#ifndef HDF4_TYPES_H
#define HDF4_TYPES_H

namespace hdf4 {

using namespace eoslib;

#define MAX_FULL_PATH_LEN 1024

#define _HDF_CHK_TBL_CLASS "_HDF_CHK_TBL_"
#define CERE_META_NAME "CERES_metadata"
#define CERE_META_FIELD_NAME "LOCALGRANULEID"
#define SENSOR_NAME "Sensor Name"
#define PRO_NAME "Product Name"
#define CER_AVG_NAME "CER_AVG"
#define CER_ES4_NAME "CER_ES4"
#define CER_CDAY_NAME "CER_ISCCP-D2like-Day"
#define CER_CGEO_NAME "CER_ISCCP-D2like-GEO"
#define CER_SRB_NAME "CER_SRBAVG3"
#define CER_SYN_NAME "CER_SYN"
#define CER_ZAVG_NAME "CER_ZAVG"

enum SPType
{ OTHERHDF, TRMML2_V6, TRMML3_V6, TRMML2_V7, TRMML3S_V7, TRMML3M_V7, CER_AVG, CER_ES4, CER_CDAY, CER_CGEO, CER_SRB, CER_SYN, CER_ZAVG, OBPGL2, OBPGL3, MODISARNSS, TRMM_3A46 };

// The NASA HDF4 products that the conversion toolkit trys to convert to follow CF 
//// TRMML2_V6: TRMM version 6 Level2 1B21,2A12,2B31,2A25
//// TRMML3_V6: TRMM version 6 Level3B 3B42,3B43
//// TRMM_3A46: TRMM version 6 Level3A 3A46 
//// TRMML2_V7: TRMM version 7 (Level 1B: 1B01,1B11,1B21,1C21,Level 2: 2A12,2A21,2A23,2A25,2B31,2B31_CSI)
//// TRMML3S_V7: TRMM version 7 single grid(3A11,3A12,3A26,3A26,3B31,3B42,3B43)
//// TRMML3M_V7: TRMM version 7 multi-grids(3A25)
//// CERES CER_AVG:_Aqua-FM3-MODIS,CER_AVG_Terra-FM1-MODIS
//// CERES CER_ES4:_Aqua-FM3_Edition1-CV
//// CERES CER_CDAY: CER_ISCCP-D2like-Day_Aqua-FM3-MODIS
//// CERES CER_CGEO: CER_ISCCP-D2like-GEO_
//// CERES CER_SRB: CER_SRBAVG3_Aqua-
//// CERES CER_SYN: CER_SYN_Aqua-
//// CERES CER_ZAVG_
//// OBPG   OBPGL2: SeaWIFS,OCTS,CZCS,MODISA,MODIST Level2
//// OBPG   OBPGL3: SeaWIFS,OCTS,CZCS,MODISA,MODIST Level3 m 
//// MODISARNSS: a special MODIS ARNSS product
//
#define PREFIX_OF_VDATA_FIELD vdf_
} //end of namespace

#endif
