/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to the processing of HDF Vdata.


*****************************************************************************/

#include "hdf4_vdata.h"

namespace hdf4 {

/*
#define VSFPACK(CAST) \
    int len = field->numrec*field->order;\
    VOIDP ptr[1]; \
    CAST buf[len]; \
    ptr[0] = &buf[0]; \
    std::vector<char> pbuf; \
    field->get_all_values(&pbuf); \
    VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&(pbuf[0]), pbuf.size(), field->numrec, NULL, ptr);
*/

// This function is for internal testing only. It is not throughly tested and is NOT used by the APIs. KY 2014-12-26
std::string generate_str_value(int32 vdata_id, hdf4_var_vdfield *field) 
{
    if(field->value.size()==0)
        return "";
	
    std::stringstream out;
    switch(field->type)
    {
#define HANDLE2(TYPE, cast) \
    case DFNT_##TYPE: \
        out << (cast)&field->value[0]; \
        field->str_value = out.str(); \
        break;

#define HANDLE3(TYPE, t, cast) \
    case DFNT_##TYPE: \
        out << (cast)*((t)&field->value[0]); \
        field->str_value = out.str(); \
        break;
        case DFNT_CHAR8: // For order(or array size)>1
        { 
            if(field->numrec>1 || field->order>1)
            { 
                //VSFPACK(char);
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //char buf[len]; 
                std::vector<char>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str;
                for(int l=0; l<=len-field->order; l+=field->order) 
                { 
                    a_str += "\""; 
                    for(size_t k=l; k<l+field->order; k++) 
                        if((char)buf[k]>31 && (char)buf[k]<127) 
                    a_str += (char)buf[k]; 
                    a_str += "\""; 
                    if(l!=len-field->order) 
                        a_str += ","; 
                } 
                out << a_str; 
             } else 
                out << *((char *)&(field->get_value())[0]); 
        } 
            break;

        case DFNT_UCHAR8: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //char buf[len]; 
                std::vector<char>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%c", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((char *)&field->value[0]); 
        } 
            break;
        case DFNT_UINT8: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //uint8 buf[len]; 
                std::vector<uint8> buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%u", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                    out << a_str; 
            } else 
                out << *((uint8 *)&field->value[0]); 
        } 
            break;
        case DFNT_INT8: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //int8 buf[len]; 
                std::vector<int8>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%d", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((int8 *)&field->value[0]); 
        } 
            break;
        case DFNT_UINT16: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //uint16 buf[len]; 
                std::vector<uint16>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%u", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((uint16 *)&field->value[0]); 
        } 
            break;
        case DFNT_INT16: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //int16 buf[len]; 
                std::vector<int16>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%d", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((int16 *)&field->value[0]); 
        } 
            break;
        case DFNT_UINT32: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //uint32 buf[len]; 
                std::vector<uint32>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%u", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((uint32 *)&field->value[0]); 
        } 
            break;
        case DFNT_INT32: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //int32 buf[len]; 
                std::vector<int32>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%d", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((int32 *)&field->value[0]); 
        } 
            break;
        case DFNT_FLOAT32: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //float buf[len]; 
                std::vector<float>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%.6f", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((float *)&field->value[0]); 
        } 
            break;
        case DFNT_FLOAT64: 
        { 
            if(field->numrec>1 || field->order>1) 
            { 
                int len = field->numrec*field->order;
                VOIDP ptr[1]; 
                //double buf[len]; 
                std::vector<double>buf;
                buf.resize(len);
                ptr[0] = &buf[0]; 
                VSfpack(vdata_id, _HDF_VSUNPACK, field->get_name().c_str(), (VOIDP)&field->value[0], field->value.size(), field->numrec, NULL, ptr); 
                std::string a_str; 
                char c[100]; 
                for(int l=0; l<len; l++) 
                { 
                    sprintf(c, "%8.3e", buf[l]); 
                    a_str.append(c); 
                    if(l!=len-1) 
                        a_str.append(","); 
                } 
                out << a_str; 
            } else 
                out << *((double *)&field->value[0]); 
        } 
            break;
        default:
            throw std::range_error("Vdata Field's type is unknown(" __FILE__ ":" TOSTRING(__LINE__)")" );
    }; // end of switch
    return out.str();
}
	
void VDATA::read_attributes(int32 vdata_id) 
{
    int32 nattrs = 0;
    int32 attrsize = 0;
    int32 status = -1;

    char attr_name[H4_MAX_NC_NAME];

    nattrs = VSfnattrs (vdata_id, _HDF_VDATA);
    if (nattrs == FAIL)
        throw std::runtime_error("VSfnattrs failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
    if (nattrs > 0) 
    {
        for (int i = 0; i < nattrs; i++) 
        {
            hdf4_attr *attr = new hdf4_attr();
            status = VSattrinfo (vdata_id, _HDF_VDATA, i, attr_name, &attr->type, &attr->count, &attrsize);
#if 0
            if(0) // For debugging only.
                std::cout << "\t\t\tattr name=" << attr_name << " type=" << attr->type << " count=" << attr->count << " size=" << attrsize << std::endl;
#endif
            std::string tmpname(attr_name);
            attr->m_name = tmpname; 
            if (status == FAIL) {
                delete attr;
                throw std::runtime_error("VSattrinfo failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
            }
            attr->value.resize (attrsize);
            if (VSgetattr (vdata_id, _HDF_VDATA, i, &attr->value[0]) == FAIL){
                 delete attr;
                throw std::runtime_error("VSgetattr failed.(" __FILE__ ":" TOSTRING(__LINE__)")" );
            }
            attrs.push_back (attr);
        } // end of for
    } // end of if (nattrs > 0
}

VDATA* VDATA::read(int32 vdata_id, int32 obj_ref)
{
    int32 fieldsize = -1;
    int32 fieldtype = -1;
    int32 fieldorder = -1;
    char *fieldname = NULL;
    char vdata_name[VSNAMELENMAX];

    VDATA *vdata = new VDATA (vdata_id, obj_ref);

    vdata->vdref = obj_ref;

    if (VSQueryname (vdata_id, vdata_name) == FAIL) {
        delete vdata;
        throw std::runtime_error("VSQueryname failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
    }

    std::string vdatanamestr (vdata_name);

    vdata->name = vdatanamestr;
    vdata->newname = vdata->name;
#if 0
    if(0) // For debugging only.
        std::cout << "vdata name=" << vdata->name << std::endl;
#endif
    int32 num_field = VFnfields (vdata_id);
    if (num_field == -1) {
        delete vdata;
        throw std::runtime_error("For vdata, VFnfields failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
    }

    int32 num_record = VSelts (vdata_id);
    if (num_record == -1){
        delete vdata;
        throw std::runtime_error("For vdata, VSelts failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
    }
		
#if 0
    if(0) // For debugging only
        std::cout << "\tnum of field=" << num_field << " num of record=" << num_record << std::endl;
#endif

    // Loop through all fields and save information to a vector
    for (int i = 0; i < num_field; i++) 
    {
        hdf4_var_vdfield *field = new hdf4_var_vdfield();
                
        fieldsize = VFfieldesize (vdata_id, i);
        if (fieldsize == FAIL) {
            delete field;
            delete vdata;
            throw std::runtime_error("For vdata field, VFfieldsize failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
        }
        fieldname = VFfieldname (vdata_id, i);
        if (fieldname == NULL) {
            delete field;
            delete vdata;
            throw std::runtime_error("For vdata field, VFfieldname failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
        }
        fieldtype = VFfieldtype (vdata_id, i);
        if (fieldtype == FAIL){
            delete field;
            delete vdata;
            throw std::runtime_error("For vdata field, VFfieldtype failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
        }
        fieldorder = VFfieldorder (vdata_id, i);
        if (fieldorder == FAIL){
            delete field;
            delete vdata;
            throw std::runtime_error("For vdata field, VFfieldtype failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
        }
	
        field->m_name = fieldname;
        field->newname = field->m_name;
        field->type = fieldtype;
        field->order = fieldorder;
        field->size = fieldsize;
        field->rank = 1;
        field->numrec = num_record;
        field->vdata_id = vdata_id;

#if 0
        if(0) // For debugging only.
            std::cout << "\t\tfield name=" << field->m_name << " type=" << field->type << " order=" << field->order << " size=" << field->size << std::endl; 			
#endif
        if ( num_record > 0) 
        { 
            // Currently we only save small size vdata to attributes
            field->value.resize (num_record * fieldsize);
            if (VSseek (vdata_id, 0) == FAIL) {
                delete field;
                delete vdata;
                throw std::runtime_error("VSeek failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
            }

            if (VSsetfields (vdata_id, fieldname) == FAIL){
                delete field;
                delete vdata;
                throw std::runtime_error("VSsetfields failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
            }
            if (VSread(vdata_id, (uint8 *) & field->value[0], num_record, FULL_INTERLACE) == FAIL) {
                delete field;
                delete vdata;
                throw std::runtime_error("VSread failed.(" __FILE__ ":" TOSTRING(__LINE__)")");
            }
       
        } // end of if
        // Read field attributes
        field->read_attributes (vdata_id, i);
        vdata->vdfields.push_back (field);
    } // end of for (int i = 0;

    // Read Vdata attributes
    vdata->read_attributes (vdata_id);

    return vdata;
}

VDATA::~VDATA() 
{
    for(std::vector<hdf4_attr *>::const_iterator i=attrs.begin(); i!=attrs.end(); i++)
        delete *i;
    for(std::vector<hdf4_var_vdfield *>::const_iterator i=vdfields.begin(); i!=vdfields.end(); i++)
        delete *i;
    VSdetach(vdata_id);
}

} //end of namespace
