/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the HDF4 namespace

Description:

This file contains the information of the HDF4 VDATA class. 
*****************************************************************************/


#ifndef HDF4_VDATA_H
#define HDF4_VDATA_H

#include "hdf.h"
#include "hdf4_attr.h"
#include "hdf4_vdata_field.h"
#include "hdf4_types.h"

using namespace eoslib;

namespace hdf4 {
class VDATA
{
    public:
        ~VDATA() ;
        // Retrieve all information of this Vdata.
        static VDATA *read (int32 vdata_id, int32 obj_ref) ;

        // Retrieve all attributes of this Vdata.
        void read_attributes (int32 vdata_id) ;

        // Obtain id.
        const int32 get_vdata_id() const 
        {
            return vdata_id;
        }

        // Obtain new names(with the path and special characters and name clashing handlings)
        const std::string & get_new_name () const
        {
            return this->newname;
        }

        // Rename newname.
        void set_new_name(std::string str) 
        {
            newname = str;
        }

        // Obtain the original vdata name
        const std::string & get_name () const
        {
            return this->name;
        }

        // Obtain Vdata fields.
        const std::vector < hdf4_var_vdfield * >&get_fields () const
        {
            return this->vdfields;
        }

        // Obtain Vdata attributes.
        const std::vector < hdf4_attr * >&get_attributes () const
        {
            return this->attrs;
        }

        // Obtain Vdata reference number, this is necessary for retrieving Vdata information from HDF4.
        int32 get_obj_ref ()
        {
            return vdref;
        }
         
     protected:
        VDATA (int32 vdata_myid, int32 obj_ref) 
            :vdata_id (vdata_myid), vdref (obj_ref) {}

    protected:

        // New name containing full path.
        std::string newname;
        // Origninal VDATA name.
        std::string name;
        // Store VDATA fields.
        std::vector < hdf4_var_vdfield * >vdfields;
        // Store VDATA attribute.
        std::vector < hdf4_attr * >attrs;
        // Reference number to VDATA.
        int32 vdref;

    private:
        int32 vdata_id;

        friend class hdf4_file;
};	
} //end of namespace

#endif
