/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Header file for the HDF4 namespace

Description:

This file includes the definition of an HDF4 vdata field and includes related 
method declarations. The class VDATA defined in the header file hdf4_vdata.h contains a 
class member that is vector of pointer of the instances of the class defined here.


*****************************************************************************/


#ifndef HDF4_VDATA_FIELD_H
#define HDF4_VDATA_FIELD_H

#include <sstream>
#include "eoslib_defs.h"
#include "hdf4_types.h"
#include "hdf4_attr.h"

using namespace eoslib;

namespace hdf4 {

using namespace eoslib;
	
class hdf4_var_vdfield : public var
{
    public:
        // Default constructor.
        hdf4_var_vdfield();

        // Default destructor.
        ~hdf4_var_vdfield();
	
        // Get the name of this field.
        const std::string & get_name () const
        {
            return this->m_name;
        }
        
        // Get the new name of this field.
        const std::string & get_new_name () const
        {
            return this->newname;
        }
        
        // Get the dimension rank of this field.
        int32 get_rank () const
        {
            return this->rank;
        }
        
        // Obtain attributes.
        std::vector < hdf4_attr * >&get_attributes () 
        {
            return this->attrs;
        }

        // Get the order of this field.
        int32 get_order ()const
        {
            return this->order;
        }

        // Get the field size.
        int32 get_field_size () const
        {
            return this->size;
        }

        // Get the number of record.
        int32 get_num_rec () const
        {
            return this->numrec;
        }

        // Get field value.
        const std::vector < char >&get_value () const
        {
            return this->value;
        }

        // Get field value and store the value in the vector user provides. 
        void get_all_values(std::vector<char> *pbuf) const
        {
            pbuf->resize(value.size());
            for(size_t k=0; k<value.size(); k++)
                (*pbuf)[k] = value[k];
        }

        // Get the string representation of this field.
        std::string get_str_value();

        // Read attributes.
        void read_attributes (int32 vdata_id_r, int32 fieldindex);

        // Get attribute by name
        hdf4_attr* get_attr_by_name(const std::string& attr_name);

        // Test whether the attribute with the specified name exists. 
        const bool has_attr(std::string) const;

        // Add a new attribute with the specified name and value.
        void add_attr_one_str(std::string, std::string);
	
        virtual value_type_t get_type() const;
        virtual void get_value(int32 start[], int32 stride[], int32 edge[], void *buf) const ;
        //virtual void get_value(int32 start[], int32 stride[], int32 edge[], std::vector<char> *buf) const  ;

        virtual var *_clone() const;
        virtual bool same_obj_test(var* v) const;

    public:
        // order: array size.
        // size:  total bytes.
        // numrec: the number of records.
        int32 order;
        int32 size; 
        int32 numrec;

        // Store field value. 
        std::vector< char > value;

        // Name plus full path.
        std::string newname;

        // rank for vdata field should either be 1 or 2.
        int32 rank;
        //type: data type.
        int32 type;

        // Store field attributes.
        std::vector< hdf4_attr * > attrs;

        int32 vdata_id;

        friend class VDATA;
        friend class hdf4_file;	
};

} //end of namespace

#endif
