/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to creating extra attributes.


*****************************************************************************/

#include "mem_attr.h"
#include <iostream>

namespace eoslib
{

mem_attr::mem_attr(group *g, const std::string& name): attr(g, name), m_type(-1)
{
}

mem_attr::mem_attr(var *v, const std::string& name): attr(v, name), m_type(-1)
{
}

mem_attr::~mem_attr()
{
}

value_type_t mem_attr::get_type() const
{
    return m_type;
}

unsigned int mem_attr::get_num_elements() const
{
    return m_rawdata.size() / get_type_size(m_type);
}

void mem_attr::get_value(void *buf) const
{
    std::copy(m_rawdata.begin(), m_rawdata.end(), (char*)buf);
}
void mem_attr::set_value(value_type_t type, unsigned int size, const void *buf)
{
    m_type = type;
    size_t tot_mem = size * get_type_size(type);
    m_rawdata.resize(tot_mem);

    std::copy((char*)buf, (char*)buf + tot_mem, m_rawdata.begin());
}

void mem_attr::set_value(const std::string& val)
{
    this->set_value(DFNT_CHAR8, val.size() + 1, val.c_str());
}

attr* mem_attr::clone() const
{
    mem_attr *a = new mem_attr(*this);
    return a;
}

bool mem_attr::same_obj_test(attr *a) const
{
    mem_attr *w = dynamic_cast<mem_attr*>(a);
    if(w==NULL)
        return false;
    if(this->m_type!= w->m_type)
        return false;
    if(this->m_rawdata!= w->m_rawdata)
        return false;
    return true;
}

} // namespace
