/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Header file for the eoslib namespace

Description:

This file includes a definition of an attribute class (mem_attr) mem_var and mem_group. It is used to create extra attributes for a variable described by the mem_var class and a group described by the mem_group.


*****************************************************************************/


#ifndef MEM_ATTR_H
#define MEM_ATTR_H

#include "eoslib_attr.h"
#include "eoslib_types.h"
#include <vector>
#include <typeinfo>

namespace eoslib
{

/**
 * This is an attribute class for mem_var and mem_group.
 * Users can use methods in this class to manuiplate extra attributes.
 */
class mem_attr: public attr
{
    public:
        mem_attr(group *g, const std::string& name);
        mem_attr(var *v, const std::string& name);
        virtual ~mem_attr();

        virtual value_type_t get_type() const;
        virtual unsigned int get_num_elements() const;
        virtual void get_value(void *buf) const;
        virtual attr *clone() const;
        virtual bool same_obj_test(attr *) const;
	
        void set_value(value_type_t type, unsigned int size, const void *buf);
        void set_value(const std::string& val);

    protected:
        value_type_t m_type;
        std::vector<char> m_rawdata;
};

} // namespace
#endif

