/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to creating extra dimensions.


*****************************************************************************/

#include "mem_dim.h"

namespace eoslib {

mem_dim::mem_dim(group *g, const std::string&name, unsigned int size):
	dim(g, name, size)
{
}

mem_dim::mem_dim(const mem_dim& r):
		dim(r)
{
}

mem_dim::~mem_dim()
{
}

dim *mem_dim::clone(group *g) const
{
    mem_dim *d = new mem_dim(*this);
    d->m_group = g;
    return d;

}

} // namespace
