/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the eoslib namespace

Description:

This file includes a definition of a dimension class used for class mem_var(defined in the file mem_var.h). 


*****************************************************************************/


#ifndef MEM_DIM_H
#define MEM_DIM_H

#include "eoslib_defs.h"
#include <vector>
#include <typeinfo>

namespace eoslib
{


//! Dimension class for mem_var 
class mem_dim: public dim
{
    public:
        mem_dim(group *g, const std::string&name, unsigned int size);
        mem_dim(const mem_dim& r);
        virtual ~mem_dim();

        virtual dim *clone(group *g) const;
};

} // namespace
#endif

