/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the eoslib namespace

Description:

This file includes the definition of a group(mem_group) class. It is used to create extra groups.

Related classes are mem_group,mem_var,mem_dim and mem_attr.

*****************************************************************************/

#ifndef MEM_GROUP_H
#define MEM_GROUP_H

#include <list>
#include <string>
#include "eoslib_defs.h"

namespace eoslib
{

class mem_group: public group
{
    public:
        mem_group(): group("/") {}
        mem_group(const std::string& name): group(name) {}
        inline virtual ~mem_group() {}

        inline virtual std::list<group*>& get_child_groups() 
            {return m_child_groups;}
        inline virtual std::list<var*>& get_vars()
            {return m_vars;}
        inline virtual std::list<dim*>& get_dims()
            {return m_dims;}
        inline virtual std::list<attr*>& get_attrs()
            {return m_attrs;}

    private:

    protected:

        std::list<group*> m_child_groups;
        std::list<var*> m_vars;
        std::list<dim*> m_dims;
        std::list<attr*> m_attrs;
};

} // namespace
#endif

