/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Header file for the eoslib namespace

Description:

This file includes a definition of a variable(mem_var) class. It is used to create extra variables.
Related classes are mem_group,mem_var,mem_dim and mem_attr.


*****************************************************************************/


#ifndef MEM_VAR_H
#define MEM_VAR_H

#include "eoslib_var.h"
#include <vector>
#include <list>

namespace eoslib
{

class mem_var: public var
{
    public:
        mem_var(group *g, const std::string& name);
        mem_var(const mem_var& r);
        virtual ~mem_var();
		
        virtual value_type_t get_type() const;

        virtual void get_value(int32 start[], int32 stride[], int32 edge[], void *buf) const;
        
        virtual var *_clone() const;

        void set(value_type_t type, const std::list<dim*>& dims, const void *buf);

        // The following two functions are added for convenience
        void set(value_type_t type, dim* d1, const void *buf);
        void set(value_type_t type, dim* d1, dim *d2, const void *buf);

        // We compare values as well for mem_var::same_obj_test
        virtual bool same_obj_test(var*) const;

    protected:
        value_type_t m_type;
        std::vector<char> m_buf;

    private:
        mem_var();

        friend class mem_group;
        friend int _cb_on_each_gdfield(char *name, void *arg);
	
};

} // namespace
#endif

