/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes utility methods of implementation for splitting a string.

*****************************************************************************/

#include "misc_util.h"
#include <cstring>
#include <cstdio>
#include <cstdlib>
#include <sys/stat.h>
#ifndef _MSC_VER
#include <unistd.h>
#else
#define strtok_r strtok_s
#endif
#include <fcntl.h>
#include <string>
#include <vector>


int util_walk_str(char *str, const char *delim, int (*func)(char*, void*), void *arg)
{
    char *saveptr=NULL;
    char *cur;

    int ret = 0;

    cur = strtok_r(str, delim, &saveptr);
    while(cur)
    {
        ret = func(cur, arg);
        if(ret)
            return ret;
        cur = strtok_r(NULL, delim, &saveptr);
    }

    return 0;
}

int _util_split_str__on_each_substr(char *substr, void *arg)
{
    void **args=(void**)arg;
    char ***pentries = (char***)args[0];
    int *pnum = (int*)args[1];

    if(*pnum==0)
        (*pentries) = (char**)malloc(sizeof(char*) * 1);
    else
        (*pentries) = (char**)realloc(*pentries, sizeof(char*) * ((*pnum)+1));
    if(*pentries == NULL)
        return -1;

    (*pentries)[*pnum] = substr;
    (*pnum)++;

    return 0;
}

int util_split_str(char *str, const char *delim, char ***pentries)
{
    void *args[2];
    int num=0;
    int ret=0;

    *pentries=NULL;
    args[0]=(void*)pentries;
    args[1]=(void*)&num;

    ret = util_walk_str(str, delim, _util_split_str__on_each_substr, (void*)args);
    if(ret)
        return -1;
    else
        return num;
}

int util_split_str(const std::string& str, 
    const std::string& delim, 
    std::vector<std::string> *ptokens)
{
    int r = 0;
    char **tokens;
    std::vector<char> d(str.begin(), str.end());
    d.push_back('\0');
    r = util_split_str(&d[0], delim.c_str(), &tokens);
    if(r < 0){
        free(tokens);
        return -1;
    }
    for(int i=0; i<r; i++)
        ptokens->push_back(tokens[i]);

    free(tokens);
    return r;
}


