/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Special utility 

Description:

This file includes utility methods used to make some special HDF-EOS2 and HDF4 products to follow CF.     


*****************************************************************************/

#ifndef SPECIAL_FLT_CF_H
#define SPECIAL_FLT_CF_H

#include "eoslib_attr.h"
#include "eoslib_var.h"
#include "hdf4_file.h"
#include <vector>

// This is the maximum number of MODIS special values.
#define MAX_NON_SCALE_SPECIAL_VALUE 65535
//
// // This is the minimum number of MODIS special values.
#define MIN_NON_SCALE_SPECIAL_VALUE 65500
//

namespace eoslib { 

// For EOS2 fill value check and change.
bool check_eos2_fill_value_attr_type(var*,value_type_t);
void change_eos2_fill_value_attr_type(var*,value_type_t);

// For MODIS products only.
value_type_t get_corrected_var_type(value_type_t, var*);
bool is_special_value(int32 dtype, float fillvalue, float realvalue);

// For MODIS products only.
void change_modis_value(var*, std::vector<char>*, int32, int32*, int32*, int32*);

// dump_attr and dump_var should be used for internal testing only.
void dump_attr(attr*, std::ostream&) throw(std::range_error);
void dump_var(var*, std::ostream&);
}

namespace hdf4 {

// For HDF4 fill value check and change.
//bool check_hdf4_fill_value_attr_type(hdf4_var_sdfield*);
void change_hdf4_fill_value_attr_type(hdf4_var_sdfield*);

}
#endif

