#!/bin/sh
#
# This script downloads NASA test data from The HDF Group's FTP server.
#
# Check whether "wget" or "curl" is available first.
GET=""
command -v  wget > /dev/null && GET="wget -N --retr-symlinks" 
if [ -z "$GET" ]; then
  command -v  curl > /dev/null && GET="curl -O"
fi

if [ -z "$GET" ]; then
  echo "Neither wget nor curl found in your system."
  exit
fi

$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/1B21_CSI.990906.10217.KORA.6.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/2A25_CSI.990804.9692.KORA.6.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2002.08.01.L3.RetStd_H031.v4.0.21.0.G06104133732.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2002.12.31.001.L2.CC_H.v5.0.14.0.G07282131425.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2003.01.15.L3.RetStd_H001.v5.0.14.0.G08102123946.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2005.01.01.L3.CO2Std031.v5.4.12.67.X09261141415.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2008.10.27.L3.RetStd001.v5.2.2.0.G08303124144.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2012.01.02.L3.CO2Std001.v5.9.14.12.X12039173640.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2012.08.01.L3.RetQuant_IR005.v5.0.14.0.G12219230647.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/MERRA100.prod.assim.inst6_3d_ana_Np.19800401.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/MERRA300.prod.assim.tavg3_3d_chm_Nv.20120630.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/MERRA300.prod.assim.tavgU_2d_chm_Fx.200201.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GHRC/LISOTD_HRAC_V2.2.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MOD04_L2.A2010001.0000.005.2010005211741.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MOD05_L2.A2010001.0000.005.2010005211557.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MOD06_L2.A2010001.0000.005.2010005213214.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MOD35_L2.A2012213.2355.005.2012214073640.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MODATML2.A2000055.0000.005.2006253045900.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MOD021KM.A2010277.1710.005.2010278082807.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MYD021KM.A2002226.0000.005.2009193222735.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MYD02HKM.A2012214.0005.005.2012214164436.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MYD08_E3.A2012201.051.2012212181340.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_AVG_Aqua-FM3-MODIS_Edition2B_007005.200510.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_ES4_Aqua-FM3_Edition1-CV_024032.200908.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_ES4_TRMM-PFM_Edition1_009001.199808.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_ES8_TRMM-PFM_Edition2_025021.20000229.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_ISCCP-D2like-Day_Aqua-FM3-MODIS_Beta1_023030.200612.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_ISCCP-D2like-GEO_Composite_Beta1_023031.200510.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_SRBAVG3_Aqua-FM3-MODIS_Edition2A_016031.200510.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_SYN_Aqua-FM3-MODIS_Edition2B_007005.20051031.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/CER_ZAVG_Aqua-FM4-MODIS_Edition2B_007005.200503.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/FLASH_TISA_Terra+Aqua_Version2H_003014.20120801.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AEROSOL_P017_O036105_F10_0020_GOM_b64-72.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_ACP_MIXTURE_F06_0021.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_AGP_P001_F01_24.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_AS_AEROSOL_FIRSTLOOK_P106_O043086_F12_0022.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_CGAL_2005_F06_0012.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_GRP_ELLIPSOID_GM_P117_O058421_BA_F03_0024.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_GRP_ELLIPSOID_GM_P157_O067161_BF_F03_0024.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_RP_GM_P095_O067128_CF_F03_0024.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_AM1_TC_ALBEDO_P223_O056884_F05_0011.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MISR_ELLIPSOID_GM_P017_O036105_DF_F03_0024_GOM_b64-72.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MOP02-20000303-L2V5.7.1.val.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MOP02-20120801-L2V8.2.2.prov.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MOP03-20000303-L3V1.0.1.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LaRC/MOP03-200112220L3V2.0.1.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MCD43C1.A2006353.004.2007012185705.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MCD43C3.A2012193.005.2012214193023.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD09GA.A2007268.h10v08.005.2007272184810.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD11_L2.A2007278.0350.005.2007280073443.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD13C2.A2007001.005.2007108072029.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MYD09A1.A2007273.h03v07.005.2007285103507.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L2A_BrightnessTemperatures_V10_200501180027_D.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L2_Ocean_V06_200206190029_D.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L2_Rain_V11_201110032059_D.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L3_5DaySnow_V09_20050126.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L3_DailyLand_V06_20050118.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L3_DailyLand_V07_20111003.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L3_DailyOcean_V03_20020619.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L3_RainGrid_V06_200206.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/AMSR_E_L3_SeaIce6km_V11_20050118.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/MOD10A1.A2000065.h00v08.005.2008237034422.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/MOD29E1D.A2009340.005.2009341094922.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/NISE_SSMISF17_20110424.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/A20021612002192.L3m_R32_NSST_4.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/A2002185000000.L2_LAC_SST.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/C1978303124834.L2_MLAC.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/C19860011986008.L3m_8D_CHLO_4.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/O1996306152450.L2_GAC.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/O19970011997031.L3m_MO_A520_9.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/S1997247162631.L2_MLAC_OC.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/S1999001.L3m_DAY_CHL_chlor_a_9km.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/T20000322000060.L3m_MO_NSST_4.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/OBPG/T2010001000000.L2_LAC_SST.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/PODAAC/2006001-2006005.s0454pfrt-bsst.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD15A2.A2012233.h35v10.005.2012242104802.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MYD09GA.A2012246.h35v10.005.2012248075505.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MYD09CMG.A2012246.005.2012248072339.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD13C1.A2012225.005.2012242130402.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD09.A2012239.2345.005.2012241035456.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/3B43.070901.6A.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2009.11.30.240.L2.CO2_Std.v5.4.11.0.CO2.T09346091404.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MOD07_L2.A2000055.0000.005.2010041143937.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LAADS/MOD15A2GFS.A2007361.h14v09.005.2009023184616.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MYD13A2.A2007025.h08v04.005.2007048111955.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MYD09GQK.A2006364.h20v05.004.2007002112253.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MYD09Q1.A2007001.h00v09.005.2007085230839.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD43B4.A2006353.h15v15.004.2007006030047.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/LPDAAC/MOD17A2.A2007113.h11v09.005.2007136163924.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/PODAAC/1990-S1700101.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/PODAAC/S2000415.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/NSIDC/MOD29.A2013196.1250.005.2013196195940.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/NASAHDF/1B21.19971208.00170.7.HDF
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/NASAHDF/2A12.20140308.92894.7.HDF
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/NASAHDF/2B31.20140108.91989.7.HDF
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/NASAHDF/3A25.20140101.7.HDF
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/NASAHDF/3B43.20130901.7.HDF
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2013.01.01.L3.RetStd001.v6.0.9.0.G13092214104.hdf
$GET https://gamma.hdfgroup.org/ftp/pub/outgoing/opendap/data/HDF4/NASA1/GESDISC/AIRS.2013.12.08.001.L2.RetStd.v6.0.7.0.G13345141819.hdf

