// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

int main(int argc, char* argv[])
{
    h4cf_open(argv[1]); // Open file and initialize library.
    const map<string, int> dimensions = h4cf_get_dims();
    // Print dimensions out as pair of "dimension name" and "dimension size".
    for(map<string, int>::const_iterator it=dimensions.begin(); 
        it!=dimensions.end(); 
        it++) 
        cout << (*it).first << " = " << (*it).second << endl;

    h4cf_close();
    return 0;
}
