// Copyright by The HDF Group
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>
// This API test prints out all variable names that has an attribute whose
// name matches the argument. 

void write_char8(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(char8);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (char8)*(char8*)&(vals[i*sizeof(char8)]) << endl;
    }
}

void write_uchar8(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(uchar8);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (uchar8)*(uchar8*)&(vals[i*sizeof(uchar8)]) << endl;
    }
}


void write_int8(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(int8);
    int i = 0;
    for (i=0; i < n ; i ++){
        // int8 is same as signed char for stream.
        // Thus, cast it as a number.
        cout 
            << static_cast<int16_t>((int8)*(int8*)&(vals[i*sizeof(int8)])) 
            << endl;
    }
}


void write_uint8(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(uint8);
    int i = 0;
    for (i=0; i < n ; i ++){
        // int8 is same as signed char for stream.
        // Thus, cast it as a number.
        cout 
            << static_cast<int16_t>((uint8)*(uint8*)&(vals[i*sizeof(uint8)]))
            << endl;
    }
}


void write_int16(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(int16);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (int16)*(int16*)&(vals[i*sizeof(int16)]) << endl;
    }
}


void write_uint16(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(uint16);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (uint16)*(uint16*)&(vals[i*sizeof(uint16)]) << endl;
    }
}

void write_int32(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(int32);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (int32)*(int32*)&(vals[i*sizeof(int32)]) << endl;
    }
}


void write_uint32(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(uint32);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (uint32)*(uint32*)&(vals[i*sizeof(uint32)]) << endl;
    }
}


void write_float32(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(float32);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (float32)*(float32*)&(vals[i*sizeof(float32)]) << endl;
    }
}

void write_float64(vector<char> vals)
{
    // Print out the values.
    int n =  vals.size() / sizeof(float64);
    int i = 0;
    for (i=0; i < n ; i ++){
        cout << (float64)*(float64*)&(vals[i*sizeof(float64)]) << endl;
    }
}

void write_values(list<var*>::const_iterator it)
{
    vector<char> vals;

    h4cf_get_var_value(&vals, (*it));
    h4cf_data_type type = h4cf_get_var_type((*it));


    switch(type){

    case DFNT_CHAR8: 
        write_char8(vals);
        break;

    case DFNT_UCHAR8: 
        write_uchar8(vals);
        break;

    case DFNT_INT8: 
        write_int8(vals);
        break;

    case DFNT_UINT8: 
        write_uint8(vals);
        break;
   
    case DFNT_INT16:
        write_int16(vals);
        break;            

    case DFNT_UINT16:
        write_uint16(vals);
        break;             

    case DFNT_INT32:
        write_int32(vals);
        break;            

    case DFNT_UINT32:
        write_uint32(vals);
        break;            


    case DFNT_FLOAT32:
        write_float32(vals);
        break;

    case DFNT_FLOAT64:
        write_float64(vals);
        break;

    default:
        cerr << "Unknown type:type=" << type << endl;
        break;
    }
}

int main(int argc, char* argv[])
{
    if (argc != 3){
        cerr << "h4cf_get_var_attr_by_name file_name attribute_name "<< endl;
        exit(1);
    }

    // Open file and initialize library.
    h4cf_open(argv[1]); 

    // Retrieve a list of variables.
    const list<var*> vars = h4cf_get_vars();

    // Count the number of variables.
    for(list<var*>::const_iterator it=vars.begin(); 
        it!=vars.end(); 
        it++) {
        if(h4cf_get_var_attr_by_name(string(argv[2]), (*it)) != NULL) {
            cout << h4cf_get_var_name((*it)) << endl;
        }
    }

    // Close the file.
    h4cf_close();
    return 0;
}
