// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

void write_type(const h4cf_data_type type)
{
    switch(type){
    case DFNT_CHAR8:
        cout << "DFNT_CHAR8" ;
        break;
    case DFNT_INT8:
        cout << "DFNT_INT8" ;
        break;
    case DFNT_UCHAR8:
        cout << "DFNT_UCHAR8" ;
        break;
    case DFNT_UINT8:
        cout << "DFNT_UINT8" ;
        break;
    case DFNT_UINT16:
        cout << "DFNT_UINT16" ;
        break;                
    case DFNT_INT16:
        cout << "DFNT_INT16" ;
        break;                
    case DFNT_UINT32:
        cout << "DFNT_UINT32" ;
        break;                
    case DFNT_INT32:
        cout << "DFNT_INT32" ;
        break;                
    case DFNT_FLOAT32:
        cout << "DFNT_FLOAT32" ;
        break;
    case DFNT_FLOAT64:
        cout << "DFNT_FLOAT64" ;
        break;
    default:
        cerr << "Unknown type:type=" << type ;
        break;
    }
    
}

void write_var_attr_type(var* v)
{
    const list<attr*> vattrs = h4cf_get_var_attrs(v);
    const h4cf_data_type type = h4cf_get_var_type(v);
    write_type(type);
    cout << " " << h4cf_get_var_name(v)
         << " has the following attributes:" << endl;


    for(list<attr*>::const_iterator vattr_iter = vattrs.begin();
        vattr_iter != vattrs.end();
        vattr_iter++){
            cout << "Attribute name=" 
                 <<(*vattr_iter)->get_name().c_str()
                 << " type=";
            write_type(h4cf_get_attr_type(*vattr_iter));
            cout << " count=";
            cout << h4cf_get_attr_count(*vattr_iter);
            cout  << endl;
    } // for(each attribute);

}
// This example code is to demonstrate how to open an HDF file and read the 
// dimensions.
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open(argv[1]); 
	
    // Print each variable's dimension name and size.
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); var_iter++){
        write_var_attr_type(*var_iter);
    }
    h4cf_close(); // Close file and library.
	
    return 0;
}
