// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

void write_type(const h4cf_data_type type)
{
    switch(type){
    case DFNT_CHAR8:
        cout << "DFNT_CHAR8" ;
        break;
    case DFNT_INT8:
        cout << "DFNT_INT8" ;
        break;
    case DFNT_UCHAR8:
        cout << "DFNT_UCHAR8" ;
        break;
    case DFNT_UINT8:
        cout << "DFNT_UINT8" ;
        break;
    case DFNT_UINT16:
        cout << "DFNT_UINT16" ;
        break;                
    case DFNT_INT16:
        cout << "DFNT_INT16" ;
        break;                
    case DFNT_UINT32:
        cout << "DFNT_UINT32" ;
        break;                
    case DFNT_INT32:
        cout << "DFNT_INT32" ;
        break;                
    case DFNT_FLOAT32:
        cout << "DFNT_FLOAT32" ;
        break;
    case DFNT_FLOAT64:
        cout << "DFNT_FLOAT64" ;
        break;
    default:
        cerr << "Unknown type:type=" << type ;
        break;
    }
    
}

int main(int argc, char* argv[])
{
    int count = 0;

    // Open file and initialize library.
    h4cf_open(argv[1]); 

    // Retrieve a list of variables.
    const list<var*> vars = h4cf_get_vars();

    // Count the number of variables.
    for(list<var*>::const_iterator it=vars.begin(); 
        it!=vars.end(); 
        it++) {
        const h4cf_data_type type = h4cf_get_var_type((*it));
        write_type(type);
        cout << " " << h4cf_get_var_name((*it)) << endl;        
    } // for


    // Close the file.
    h4cf_close();
    return 0;
}
