// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

int main(int argc, char* argv[])
{
    int count = 0;

    // Open file and initialize library.
    h4cf_open(argv[1]); 

    // Retrieve a list of variables.
    const list<var*> vars = h4cf_get_vars();

    // Count the number of variables.
    for(list<var*>::const_iterator it=vars.begin(); 
        it!=vars.end(); 
        it++) 
        ++count;
    // Print out the count.
   cout << count << endl;

    // Close the file.
    h4cf_close();
    return 0;
}
