#
# Copyright by The HDF Group.
# All rights reserved.
#
# This file is part of H4H5TOOLS.  The full H4H5TOOLS copyright notice, including
# terms governing use, modification, and redistribution, is contained in
# the COPYING file, which can be found at the root of the source code
# distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.
# If you do not have access to either file, you may request a copy from
# help@hdfgroup.org.
#

#-----------------------------------------------------------------------------
# Options for HDF Filters
#-----------------------------------------------------------------------------

include (ExternalProject)
#option (HDF_ALLOW_EXTERNAL_SUPPORT "Allow External Library Building (NO GIT TGZ)" "NO")
set (HDF_ALLOW_EXTERNAL_SUPPORT "NO" CACHE STRING "Allow External Library Building (NO GIT TGZ)")
set_property (CACHE HDF_ALLOW_EXTERNAL_SUPPORT PROPERTY STRINGS NO GIT TGZ)
option (HDF4_USE_EXTERNAL "Use External Library Building for HDF4" 0)
option (HDF5_USE_EXTERNAL "Use External Library Building for HDF5" 0)
if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
  set (HDF4_USE_EXTERNAL 1 CACHE BOOL "Use External Library Building for HDF4" FORCE)
  set (HDF5_USE_EXTERNAL 1 CACHE BOOL "Use External Library Building for HDF5" FORCE)
  if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT")
    set (HDF4_URL ${HDF4_GIT_URL} CACHE STRING "Path to hdf git repository")
    set (HDF4_BRANCHL ${HDF4_GIT_BRANCH})
    set (HDF5_URL ${HDF5_GIT_URL} CACHE STRING "Path to hdf5 git repository")
    set (HDF5_BRANCH ${HDF5_GIT_BRANCH})
  elseif (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    if (NOT TGZPATH)
      set (TGZPATH ${H4H5_SOURCE_DIR})
    endif ()
    set (HDF4_URL ${TGZPATH}/${HDF4_TGZ_NAME})
    set (HDF5_URL ${TGZPATH}/${HDF5_TGZ_NAME})
  endif ()
endif ()

#-----------------------------------------------------------------------------
# HDF4 support
#-----------------------------------------------------------------------------
if (NOT BUILD_SHARED_LIBS)
  set (HDF4_USE_STATIC_LIBRARIES 1)
endif ()

HDF4_SUPPORT(true)

#-----------------------------------------------------------------------------
# HDF5 support
#-----------------------------------------------------------------------------
if (NOT BUILD_SHARED_LIBS)
  set (HDF5_USE_STATIC_LIBRARIES 1)
endif ()

HDF5_SUPPORT(true)

set (LINK_LIBS ${LINK_LIBS} ${HDF5_LINK_LIBS} ${HDF4_LINK_LIBS})
message (STATUS "H4H5 link libs: ${LINK_LIBS}")
set (LINK_SHLIBS ${LINK_SHLIBS} ${HDF5_LINK_SHLIBS} ${HDF4_LINK_SHLIBS})
message (STATUS "H4H5 shared link libs: ${LINK_SHLIBS}")

