#
# Copyright by The HDF Group.
# All rights reserved.
#
# This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
# including terms governing use, modification, and redistribution, is
# contained in the COPYING file, which can be found at the root of the
# source code distribution tree. The copyright notice can also be found
# at https://www.hdfgroup.org/licenses.  If you do not have access to
# either file, you may request a copy from help@hdfgroup.org.
#
#-----------------------------------------------------------------------------
# Include all the necessary files for macros
#-----------------------------------------------------------------------------
set (HDF_PREFIX "H4H5")
include (${HDF_RESOURCES_EXT_DIR}/ConfigureChecks.cmake)

#-----------------------------------------------------------------------------
# Option to allow conversion of HDF4-EOS2 files
#-----------------------------------------------------------------------------
option (H4H5_ENABLE_EOS2 "Allow conversions of HDF4-EOS2 files" ON)
if (H4H5_ENABLE_EOS2)
  set (H4H5_HAVE_EOS2 1)
endif (H4H5_ENABLE_EOS2)
if (NOT WINDOWS)
  # Linux Specific flags
  if (CYGWIN)
    set (HDF_EXTRA_FLAGS -D_BSD_SOURCE)
  else (CYGWIN)
    set (HDF_EXTRA_FLAGS -D_POSIX_SOURCE -D_BSD_SOURCE)
  endif (CYGWIN)
endif (NOT WINDOWS)

add_definitions (${HDF_EXTRA_FLAGS})
