#
# Copyright by The HDF Group.
# All rights reserved.
#
# This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
# including terms governing use, modification, and redistribution, is
# contained in the COPYING file, which can be found at the root of the
# source code distribution tree. The copyright notice can also be found
# at https://www.hdfgroup.org/licenses.  If you do not have access to
# either file, you may request a copy from help@hdfgroup.org.
#

#-------------------------------------------------------------------------------
macro (EXTERNAL_HDF4_LIBRARY compress_type libtype)
  set (HDF45_BUILD_XDR_LIB OFF)
  if (WIN32)
    set (HDF45_BUILD_XDR_LIB ON)
  endif ()
  if (${compress_type} MATCHES "GIT")
    EXTERNALPROJECT_ADD (HDF4
        GIT_REPOSITORY ${HDF4_URL}
        GIT_TAG ${HDF4_BRANCH}
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_PDB_OUTPUT_DIRECTORY:PATH=${CMAKE_PDB_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF4_BUILD_TOOLS:BOOL=OFF
            -DHDF4_BUILD_FORTRAN:BOOL=OFF
            -DHDF4_BUILD_EXAMPLES:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF4_BUILD_XDR_LIB:BOOL=${HDF45_BUILD_XDR_LIB}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF4_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF4_ALLOW_EXTERNAL_SUPPORT:STRING="GIT"
            -DJPEG_GIT_URL:STRING=${JPEG_GIT_URL}
            -DJPEG_GIT_BRANCH:STRING=${JPEG_GIT_BRANCH}
            -DZLIB_GIT_URL:STRING=${ZLIB_GIT_URL}
            -DZLIB_GIT_BRANCH:STRING=${ZLIB_GIT_BRANCH}
            -DSZIP_GIT_URL:STRING=${SZIP_GIT_URL}
            -DSZIP_GIT_BRANCH:STRING=${SZIP_GIT_BRANCH}
            -DHDF4_ENABLE_JPEG_LIB_SUPPORT:BOOL=${HDF_ENABLE_JPEG_LIB_SUPPORT}
            -DHDF4_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF4_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF4_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
            -DCMAKE_TOOLCHAIN_FILE:STRING=${CMAKE_TOOLCHAIN_FILE}
            -DHDF_PACKAGE_NAMESPACE=${H4H5_HDF_PACKAGE_NAMESPACE}
    )
  elseif (${compress_type} MATCHES "TGZ")
    EXTERNALPROJECT_ADD (HDF4
        URL ${HDF4_URL}
        URL_MD5 ""
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_PDB_OUTPUT_DIRECTORY:PATH=${CMAKE_PDB_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF4_BUILD_TOOLS:BOOL=OFF
            -DHDF4_BUILD_FORTRAN:BOOL=OFF
            -DHDF4_BUILD_EXAMPLES:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF4_BUILD_XDR_LIB:BOOL=${HDF45_BUILD_XDR_LIB}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF4_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF4_ALLOW_EXTERNAL_SUPPORT:STRING="TGZ"
            -DTGZPATH:STRING=${TGZPATH}
            -DJPEG_TGZ_NAME:STRING=${JPEG_TGZ_NAME}
            -DZLIB_TGZ_NAME:STRING=${ZLIB_TGZ_NAME}
            -DSZIP_TGZ_NAME:STRING=${SZIP_TGZ_NAME}
            -DHDF4_ENABLE_JPEG_LIB_SUPPORT:BOOL=${HDF_ENABLE_JPEG_LIB_SUPPORT}
            -DHDF4_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF4_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF4_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
            -DCMAKE_TOOLCHAIN_FILE:STRING=${CMAKE_TOOLCHAIN_FILE}
            -DHDF_PACKAGE_NAMESPACE=${H4H5_HDF_PACKAGE_NAMESPACE}
    )
  endif ()
  externalproject_get_property (HDF4 BINARY_DIR SOURCE_DIR)

  # Create imported target dependencies
  add_library(${H4H5_HDF_PACKAGE_NAMESPACE}jpeg-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}jpeg-static "jpeg" STATIC "")
  add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}jpeg-static HDF4)
  add_library(${H4H5_HDF_PACKAGE_NAMESPACE}szip-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}szip-static "szip" STATIC "")
  add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}szip-static HDF4)
  add_library(${H4H5_HDF_PACKAGE_NAMESPACE}zlib-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}zlib-static "zlib" STATIC "")
  add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}zlib-static HDF4)
  set (HDF4_STATIC_COMP_LIBRARY "${H4H5_HDF_PACKAGE_NAMESPACE}jpeg-static;${H4H5_HDF_PACKAGE_NAMESPACE}szip-static;${H4H5_HDF_PACKAGE_NAMESPACE}zlib-static")

  # Create imported target hdf-static
  add_library(${H4H5_HDF_PACKAGE_NAMESPACE}hdf-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}hdf-static "hdf" STATIC "")
  add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}hdf-static HDF4)

  # Create imported target mfhdf-static
  add_library(${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-static "mfhdf" STATIC "")
  add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-static HDF4)

  set (HDF4_STATIC_LIBRARY ${HDF4_STATIC_COMP_LIBRARY} "${H4H5_HDF_PACKAGE_NAMESPACE}hdf-static;${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-static")

  if (HDF45_BUILD_XDR_LIB)
    add_library (${H4H5_HDF_PACKAGE_NAMESPACE}xdr-static STATIC IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}xdr-static "xdr" STATIC "")
    add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}xdr-static HDF4)
    set (HDF4_STATIC_LIBRARY "${HDF4_STATIC_LIBRARY};${H4H5_HDF_PACKAGE_NAMESPACE}xdr-static")
    set_target_properties(${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-static PROPERTIES
        INTERFACE_LINK_LIBRARIES "${H4H5_HDF_PACKAGE_NAMESPACE}xdr-static;${H4H5_HDF_PACKAGE_NAMESPACE}hdf-static"
    )
  endif ()
  set (HDF4_LIBRARIES ${HDF4_STATIC_LIBRARY})

  if (BUILD_SHARED_LIBS)
    # Create imported target hdf-shared
    add_library(${H4H5_HDF_PACKAGE_NAMESPACE}hdf-shared SHARED IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}hdf-shared "hdf" SHARED "")
    add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}hdf-shared HDF4)

    # Create imported target mfhdf-shared
    add_library(${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-shared SHARED IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-shared "mfhdf" SHARED} "")
    add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-shared HDF4)

    set (HDF4_SHARED_LIBRARY ${HDF4_STATIC_COMP_LIBRARY} "${H4H5_HDF_PACKAGE_NAMESPACE}hdf-shared;${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-shared")

    if (HDF45_BUILD_XDR_LIB)
      add_library (${H4H5_HDF_PACKAGE_NAMESPACE}xdr-shared SHARED IMPORTED)
      HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF_PACKAGE_NAMESPACE}xdr-shared "xdr" SHARED "")
      add_dependencies (${H4H5_HDF_PACKAGE_NAMESPACE}xdr-shared HDF4)
      set (HDF4_SHARED_LIBRARY "${HDF4_SHARED_LIBRARY};${H4H5_HDF_PACKAGE_NAMESPACE}xdr-shared")
      set_target_properties(${H4H5_HDF_PACKAGE_NAMESPACE}mfhdf-shared PROPERTIES
          INTERFACE_LINK_LIBRARIES "${H4H5_HDF_PACKAGE_NAMESPACE}xdr-shared;${H4H5_HDF_PACKAGE_NAMESPACE}hdf-shared"
    )
    endif ()
    set (HDF4_LIBRARIES ${HDF4_LIBRARIES} ${HDF4_SHARED_LIBRARY})
  endif ()

  message ("HDF4_STATIC_LIBRARY is ${HDF4_STATIC_LIBRARY}\n")
  if (BUILD_SHARED_LIBS)
    message ("HDF4_SHARED_LIBRARY is ${HDF4_SHARED_LIBRARY}\n")
  endif ()

  # Create imported target ${H4H5_HDF_PACKAGE_NAMESPACE}hdp
  add_executable(${H4H5_HDF_PACKAGE_NAMESPACE}hdp IMPORTED)

  # Create imported target ${H4H5_HDF_PACKAGE_NAMESPACE}hdfimport
  add_executable(${H4H5_HDF_PACKAGE_NAMESPACE}hdfimport IMPORTED)

  set (HDF4_INCLUDE_DIR_GEN "${BINARY_DIR}")
  set (HDF4_HDF_INCLUDE_DIR "${SOURCE_DIR}/hdf/src")
  set (HDF4_MFHDF_INCLUDE_DIR "${SOURCE_DIR}/mfhdf/libsrc")
  set (HDF4_INCLUDE_DIR ${HDF4_HDF_INCLUDE_DIR} ${HDF4_MFHDF_INCLUDE_DIR})
  set (HDF4_FOUND 1)
  set (HDF4_INCLUDE_DIRS ${HDF4_INCLUDE_DIR_GEN} ${HDF4_INCLUDE_DIR})
endmacro ()

#-------------------------------------------------------------------------------
macro (PACKAGE_HDF4_LIBRARY compress_type libtype)
  add_custom_target (HDF4-GenHeader-Copy ALL
      COMMAND ${CMAKE_COMMAND} -E copy_if_different ${HDF4_INCLUDE_DIR_GEN}/h4config.h ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/
      COMMENT "Copying ${HDF4_INCLUDE_DIR_GEN}/h4config.h to ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/"
  )
  set (EXTERNAL_HEADER_LIST ${EXTERNAL_HEADER_LIST} ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/h4config.h)
  if (${compress_type} MATCHES "GIT" OR ${compress_type} MATCHES "TGZ")
    add_dependencies (HDF4-GenHeader-Copy HDF4)
    install (
        FILES ${HDF4_INCLUDE_DIR_GEN}/libhdf4.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  else ()
    get_filename_component (HDF4SETTINGS "${HDF4_INCLUDE_DIR}/../lib" ABSOLUTE)
    install (
        FILES ${HDF4SETTINGS}/libhdf4.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  endif ()
endmacro ()

macro (HDF4_SUPPORT link_hdf)
  set (CMAKE_MODULE_PATH ${HDF_RESOURCES_DIR} ${CMAKE_MODULE_PATH})
  set (CMAKE_POSITION_INDEPENDENT_CODE ON)

  if (NOT H4H5_HDF4_HEADER)
    if (NOT HDF4_USE_EXTERNAL)
      if (BUILD_SHARED_LIBS)
        set (FIND_HDF_COMPONENTS C shared static)
      else ()
        set (FIND_HDF_COMPONENTS C static)
      endif ()
      message (STATUS "HDF4 find comps: ${FIND_HDF_COMPONENTS}")
      set (SEARCH_PACKAGE_NAME ${HDF4_PACKAGE_NAME})

      find_package (HDF4 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
      message (STATUS "HDF4 C libs:${HDF4_FOUND} static:${HDF4_static_C_FOUND} and shared:${HDF4_shared_C_FOUND}")
      if (HDF4_FOUND)
        if (NOT HDF4_static_C_FOUND AND NOT HDF4_shared_C_FOUND)
          # Use older single package finder logic
          set (FIND_HDF_COMPONENTS C)
          message (STATUS "HDF4 find comps: ${FIND_HDF_COMPONENTS}")
          find_package (HDF4 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
          message (STATUS "HDF4 libs:${HDF4_FOUND} C:${HDF4_C_FOUND}")
          set (HDF4_LINK_LIBS ${HDF4_LINK_LIBS} ${HDF4_LIBRARIES})
          if (HDF4_BUILD_SHARED_LIBS)
            add_definitions (-DH4_BUILT_AS_DYNAMIC_LIB)
          else ()
            add_definitions (-DH4_BUILT_AS_STATIC_LIB)
          endif ()
          if (BUILD_SHARED_LIBS AND WIN32)
            set_property (TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdp PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdpdll")
            set_property (TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdiff PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdiffdll")
          else ()
            set_property (TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdp PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdp")
            set_property (TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdiff PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdiff")
          endif ()
          set (HDF4_DUMP_EXECUTABLE $<TARGET_FILE:${H4H5_HDF_PACKAGE_NAMESPACE}hdp>)
          set (HDF4_DIFF_EXECUTABLE $<TARGET_FILE:${H4H5_HDF_PACKAGE_NAMESPACE}hdiff>)
        else ()
          # Use dual package finder logic
          if (BUILD_SHARED_LIBS AND HDF4_shared_C_FOUND)
            set (HDF4_LINK_SHLIBS ${HDF4_LINK_SHLIBS} ${HDF4_C_SHARED_LIBRARY})
            if (NOT TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdp-shared)
              add_executable (${H4H5_HDF_PACKAGE_NAMESPACE}hdp-shared IMPORTED)
            endif()
            if (NOT TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdiff-shared)
              add_executable (${H4H5_HDF_PACKAGE_NAMESPACE}hdiff-shared IMPORTED)
            endif()
            set (HDF4_DUMP_EXECUTABLE $<TARGET_FILE:${H4H5_HDF_PACKAGE_NAMESPACE}hdp-shared>)
            set (HDF4_DIFF_EXECUTABLE $<TARGET_FILE:${H4H5_HDF_PACKAGE_NAMESPACE}hdiff-shared>)
            set (HDF4_LIBRARY_PATH ${PACKAGE_PREFIX_DIR}/lib)
          endif ()
          if (HDF4_static_C_FOUND)
            set (HDF4_LINK_LIBS ${HDF4_LINK_LIBS} ${HDF4_C_STATIC_LIBRARY})
            if (NOT TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdp)
              add_executable (${H4H5_HDF_PACKAGE_NAMESPACE}hdp IMPORTED)
            endif()
            if (NOT TARGET ${H4H5_HDF_PACKAGE_NAMESPACE}hdiff)
              add_executable (${H4H5_HDF_PACKAGE_NAMESPACE}hdiff IMPORTED)
            endif()
            set (HDF4_DUMP_EXECUTABLE $<TARGET_FILE:${H4H5_HDF_PACKAGE_NAMESPACE}hdp>)
              set (HDF4_DIFF_EXECUTABLE $<TARGET_FILE:${H4H5_HDF_PACKAGE_NAMESPACE}hdiff>)
          endif ()
        endif ()
      endif ()
    else ()
      if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        # May need to build JPEG with PIC on x64 machines with gcc
        # Need to use CMAKE_ANSI_CFLAGS define so that compiler test works
        if (NOT CMAKE_ANSI_CFLAGS)
          set (CMAKE_ANSI_CFLAGS " ")
        endif ()
        if (BUILD_JPEG_WITH_PIC)
          set (CMAKE_ANSI_CFLAGS "${CMAKE_ANSI_CFLAGS} -fPIC")
        endif ()

        EXTERNAL_HDF4_LIBRARY (${HDF_ALLOW_EXTERNAL_SUPPORT} ${LIB_TYPE})
        set (H4H5_HAVE_HDF_H 1)
        set (H4H5_HAVE_HDF4 1)
        set (H4H5_HDF4_HEADER "hdf.h")
        message (STATUS "HDF4 is built")
        set (HDF4_LINK_LIBS ${HDF4_LINK_LIBS} ${HDF4_STATIC_LIBRARY})
        if (BUILD_SHARED_LIBS)
          set (HDF4_LINK_SHLIBS ${HDF4_LINK_SHLIBS} ${HDF4_SHARED_LIBRARY})
        endif ()
      else ()
        message (FATAL_ERROR " HDF4 is Required for H4H5Tools")
      endif ()
    endif ()
    if (HDF4_FOUND)
      message (STATUS "HDF4-${HDF4_VERSION_STRING} found: INC=${HDF4_INCLUDE_DIR} TOOLS=${HDF4_TOOLS_DIR}")
      if (USE_SHARED_LIBS AND NOT HDF4_BUILD_SHARED_LIBS)
        message (STATUS "HDF4 build type does match requested type")
      endif ()
      set (H4H5_HAVE_HDF_H 1)
      set (H4H5_HAVE_HDF4 1)
      set (H4H5_HDF4_HEADER "hdf.h")
      set (HDF4_INCLUDE_DIR_GEN ${HDF4_INCLUDE_DIR_GEN})
      set (HDF4_INCLUDE_DIRS ${HDF4_INCLUDE_DIR_GEN} ${HDF4_INCLUDE_DIR})
    else ()
      message (FATAL_ERROR " HDF4 is Required for H4H5Tools")
    endif ()
  else ()
    # This project is being called from within another and HDF4 is already configured
    set (H4H5_HAVE_HDF_H 1)
    set (H4H5_HAVE_HDF4 1)
  endif ()
  message (STATUS "HDF4 link libs: ${HDF4_LINK_LIBS}")
  if (BUILD_SHARED_LIBS)
    message (STATUS "HDF4 shared link libs: ${HDF4_LINK_SHLIBS}")
  endif ()

  if (NOT HDF4_LIBRARY)
    set (HDF4_LIBRARY ${HDF4_LIBRARIES})
  endif ()
  set (HDF4_FOUND 1)
  set (HDF4_INCLUDE_DIR_GEN ${HDF4_INCLUDE_DIR_GEN})
  set (HDF4_VERSION_STRING ${HDF4_VERSION_STRING})
  if (WIN32)
    set(CMAKE_TEST_LIB_DIRECTORY "${CMAKE_TEST_LIB_DIRECTORY};${HDF4_TOOLS_DIR}")
  else ()
    set(CMAKE_TEST_LIB_DIRECTORY "${CMAKE_TEST_LIB_DIRECTORY};${HDF4_LIBRARY_PATH}")
  endif ()
endmacro ()

#-------------------------------------------------------------------------------
macro (EXTERNAL_HDF5_LIBRARY compress_type libtype)
  if (${compress_type} MATCHES "GIT")
    EXTERNALPROJECT_ADD (HDF5
        GIT_REPOSITORY ${HDF5_URL}
        GIT_TAG ${HDF5_BRANCH}
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_PDB_OUTPUT_DIRECTORY:PATH=${CMAKE_PDB_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_BUILD_TOOLS:BOOL=OFF
            -DHDF5_BUILD_EXAMPLES:BOOL=OFF
            -DHDF5_BUILD_HL_LIB:BOOL=ON
            -DHDF5_BUILD_CPP_LIB:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="GIT"
            -DZLIB_GIT_URL:STRING=${ZLIB_GIT_URL}
            -DZLIB_GIT_BRANCH:STRING=${ZLIB_GIT_BRANCH}
            -DSZIP_GIT_URL:STRING=${SZIP_GIT_URL}
            -DSZIP_GIT_BRANCH:STRING=${SZIP_GIT_BRANCH}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
            -DCMAKE_TOOLCHAIN_FILE:STRING=${CMAKE_TOOLCHAIN_FILE}
            -DHDF_PACKAGE_NAMESPACE=${H4H5_HDF5_PACKAGE_NAMESPACE}
    )
  endif ()
  if (${compress_type} MATCHES "TGZ")
    EXTERNALPROJECT_ADD (HDF5
        URL ${HDF5_URL}
        URL_MD5 ""
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_PDB_OUTPUT_DIRECTORY:PATH=${CMAKE_PDB_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_BUILD_TOOLS:BOOL=OFF
            -DHDF5_BUILD_EXAMPLES:BOOL=OFF
            -DHDF5_BUILD_HL_LIB:BOOL=ON
            -DHDF5_BUILD_CPP_LIB:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="TGZ"
            -DTGZPATH:STRING=${TGZPATH}
            -DZLIB_TGZ_NAME:STRING=${ZLIB_TGZ_NAME}
            -DSZIP_TGZ_NAME:STRING=${SZIP_TGZ_NAME}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
            -DCMAKE_TOOLCHAIN_FILE:STRING=${CMAKE_TOOLCHAIN_FILE}
            -DHDF_PACKAGE_NAMESPACE=${H4H5_HDF5_PACKAGE_NAMESPACE}
    )
  endif ()
  externalproject_get_property (HDF5 BINARY_DIR SOURCE_DIR)

  # Create imported target dependencies
  add_library(${H4H5_HDF5_PACKAGE_NAMESPACE}szip-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF5_PACKAGE_NAMESPACE}szip-static "szip" STATIC "")
  add_dependencies (${H4H5_HDF5_PACKAGE_NAMESPACE}szip-static HDF4)
  add_library(${H4H5_HDF5_PACKAGE_NAMESPACE}zlib-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF5_PACKAGE_NAMESPACE}zlib-static "zlib" STATIC "")
  add_dependencies (${H4H5_HDF5_PACKAGE_NAMESPACE}zlib-static HDF4)
  set (HDF5_STATIC_COMP_LIBRARY "${H4H5_HDF5_PACKAGE_NAMESPACE}szip-static;${H4H5_HDF5_PACKAGE_NAMESPACE}zlib-static")

  # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-static
  add_library(${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-static "hdf5" STATIC "")
  add_dependencies (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-static HDF5)
  set (HDF5_STATIC_LIBRARY "${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-static")

  # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-static
  add_library(${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-static "hdf5" STATIC "")
  add_dependencies (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-static HDF5)
  set (HDF5_STATIC_LIBRARY ${HDF5_STATIC_LIBRARY} ${HDF5_STATIC_COMP_LIBRARY} "${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-static")

  # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff
  add_executable(${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff IMPORTED)

  # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump
  add_executable(${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump IMPORTED)

  # Create imported target hdf5
  if (BUILD_SHARED_LIBS)
    # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-shared
    add_library(${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-shared SHARED IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-shared "hdf5" SHARED "")
    add_dependencies (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-shared HDF5)
    set (HDF5_SHARED_LIBRARY "${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5-shared")

    # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-shared
    add_library(${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-shared SHARED IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-shared "hdf5" SHARED "")
    add_dependencies (${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-shared HDF5)
    set (HDF5_SHARED_LIBRARY ${HDF5_SHARED_LIBRARY} ${HDF5_STATIC_COMP_LIBRARY} "${H4H5_HDF5_PACKAGE_NAMESPACE}hdf5_hl-static")

    # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff-shared
    add_executable(${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff-shared IMPORTED)

    # Create imported target ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump-shared
    add_executable(${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump-shared IMPORTED)
  endif ()

  set (HDF5_INCLUDE_DIR_GEN "${BINARY_DIR}")
  set (HDF5_INCLUDE_DIR "${SOURCE_DIR}/src;${SOURCE_DIR}/hl/src")
  set (HDF5_FOUND 1)

  message ("HDF5_STATIC_LIBRARY is ${HDF4_STATIC_LIBRARY}\n")
  if (BUILD_SHARED_LIBS)
    message ("HDF5_SHARED_LIBRARY is ${HDF4_SHARED_LIBRARY}\n")
  endif ()

  set (HDF5_INCLUDE_DIRS ${HDF5_INCLUDE_DIR_GEN} ${HDF5_INCLUDE_DIR})
endmacro ()

#-------------------------------------------------------------------------------
macro (PACKAGE_HDF5_LIBRARY compress_type libtype)
  add_custom_target (HDF5-GenHeader-Copy ALL
      COMMAND ${CMAKE_COMMAND} -E copy_if_different ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/
      COMMENT "Copying ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h to ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/"
  )
  set (EXTERNAL_HEADER_LIST ${EXTERNAL_HEADER_LIST} ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/H5pubconf.h)
  if (${compress_type} MATCHES "GIT" OR ${compress_type} MATCHES "TGZ")
    add_dependencies (HDF5-GenHeader-Copy HDF5)
    install (
        FILES ${HDF5_INCLUDE_DIR_GEN}/libhdf5.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  else ()
    get_filename_component (HDF5SETTINGS "${HDF5_INCLUDE_DIR}/../lib" ABSOLUTE)
    install (
        FILES ${HDF5SETTINGS}/libhdf5.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  endif ()
endmacro ()

macro (HDF5_SUPPORT link_hdf)
  set (CMAKE_MODULE_PATH ${HDF_RESOURCES_DIR} ${CMAKE_MODULE_PATH})
  set (CMAKE_POSITION_INDEPENDENT_CODE ON)

  if (NOT HDF5_HDF5_HEADER)
    if (NOT HDF5_USE_EXTERNAL)
      if (BUILD_SHARED_LIBS)
        set (FIND_HDF_COMPONENTS C HL shared static)
      else ()
        set (FIND_HDF_COMPONENTS C HL static)
      endif ()
      message (STATUS "HDF5 find comps: ${FIND_HDF_COMPONENTS}")
      set (SEARCH_PACKAGE_NAME ${HDF5_PACKAGE_NAME})

      find_package (HDF5 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
      message (STATUS "HDF5 C libs:${HDF5_FOUND} static:${HDF5_static_C_FOUND} and shared:${HDF5_shared_C_FOUND}")
      if (HDF5_FOUND)
        if (NOT HDF5_static_C_FOUND AND NOT HDF5_shared_C_FOUND)
          #find library from non-dual-binary package
          set (FIND_HDF_COMPONENTS C HL)
          find_package (HDF5 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
          message (STATUS "HDF5 libs:${HDF5_FOUND} C:${HDF5_C_FOUND}")
          set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_LIBRARIES})
          if (HDF5_BUILD_SHARED_LIBS)
            set (HDF5_LINK_SHLIBS ${HDF5_LINK_LIBS})
            add_definitions (-DH5_BUILT_AS_DYNAMIC_LIB)
          else ()
            add_definitions (-DH5_BUILT_AS_STATIC_LIB)
          endif ()
          if (BUILD_SHARED_LIBS AND WIN32)
            set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dumpdll")
            set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diffdll")
          else ()
            set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump")
            set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff")
          endif ()
          set (HDF5_DUMP_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump>)
          set (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff>)
        else ()
          if (BUILD_SHARED_LIBS)
            if(HDF5_shared_C_FOUND)
              set (HDF5_LINK_SHLIBS ${HDF5_LINK_SHLIBS} ${HDF5_C_SHARED_LIBRARY})
              set (HDF5_LIBRARY_PATH ${PACKAGE_PREFIX_DIR}/lib)
              if (NOT TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump-shared)
                add_executable (${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump-shared IMPORTED)
              endif()
              if (NOT TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff-shared)
                add_executable (${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff-shared IMPORTED)
              endif()
              set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump-shared PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump-shared")
              set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff-shared PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff-shared")
            endif ()
            if (HDF5_shared_HL_FOUND)
              set (HDF5_LINK_SHLIBS ${HDF5_LINK_SHLIBS} ${HDF5_HL_SHARED_LIBRARY})
            endif ()
            set (HDF5_DUMP_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump-shared>)
            set (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff-shared>)
          endif ()
          if (HDF5_static_C_FOUND)
            set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_C_STATIC_LIBRARY})
            if (NOT TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump)
              add_executable (${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump IMPORTED)
            endif()
            if (NOT TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff)
              add_executable (${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff IMPORTED)
            endif()
            set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump")
            set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff")
            if (HDF5_static_HL_FOUND)
              set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_HL_STATIC_LIBRARY})
            endif ()
            set (HDF5_DUMP_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump>)
            set (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff>)
          endif ()
        endif ()
      else ()
        find_package (HDF5) # Legacy find
        #Legacy find_package does not set HDF5_BUILD_SHARED_LIBS, so we set it here
        if (USE_SHARED_LIBS AND EXISTS "${HDF5_LIBRARY_DIRS}/libhdf5.so")
          set (HDF5_BUILD_SHARED_LIBS 1)
        else ()
          set (HDF5_BUILD_SHARED_LIBS 0)
        endif ()
        set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_LIBRARIES})
        set (HDF5_LINK_SHLIBS ${HDF5_LINK_SHLIBS} ${HDF5_LIBRARIES})
        set (LINK_LIBS ${LINK_LIBS} ${HDF5_LIBRARIES})
        set (LINK_SHLIBS ${LINK_SHLIBS} ${HDF5_LIBRARIES})
        add_executable (${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump IMPORTED)
        add_executable (${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff IMPORTED)
        set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump")
        set_property (TARGET ${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff")
        set (HDF5_DUMP_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5dump>)
        set (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:${H4H5_HDF5_PACKAGE_NAMESPACE}h5diff>)
      endif ()
    endif ()

    if (HDF5_FOUND)
      message (STATUS "HDF5 found: INC=${HDF5_INCLUDE_DIR}")
      if (USE_SHARED_LIBS AND NOT HDF5_BUILD_SHARED_LIBS)
        message (STATUS "HDF5 build type does match requested type")
      endif ()
      set (H4H5_HAVE_H5PUBCONF_H 1)
      set (H4H5_HAVE_HDF5 1)
      set (H4H5_HDF5_HEADER "h5pubconf.h")
      set (HDF5_INCLUDE_DIR_GEN ${HDF5_INCLUDE_DIR})
      set (HDF5_INCLUDE_DIRS ${HDF5_INCLUDE_DIR})
    else ()
      if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        EXTERNAL_HDF5_LIBRARY (${HDF_ALLOW_EXTERNAL_SUPPORT} ${LIB_TYPE})
        set (H4H5_HAVE_H5PUBCONF_H 1)
        set (H4H5_HAVE_HDF5 1)
        set (H4H5_HDF5_HEADER "h5pubconf.h")
        message (STATUS "HDF5 is built")
        if (USE_SHARED_LIBS)
            set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_SHARED_LIBRARY})
        else ()
            set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_STATIC_LIBRARY})
        endif ()
      else ()
        message (FATAL_ERROR " HDF5 is Required for H4H5Tools")
      endif ()
    endif ()
  else ()
    # This project is being called from within another and HDF5 is already configured
    set (H4H5_HAVE_H5PUBCONF_H 1)
    set (H4H5_HAVE_HDF5 1)
  endif ()

  message (STATUS "HDF5 link libs: ${HDF5_LINK_LIBS}")
  if (BUILD_SHARED_LIBS)
    message (STATUS "HDF5 shared link libs: ${HDF5_LINK_SHLIBS}")
  endif ()

  if (NOT HDF5_LIBRARY)
    set (HDF5_LIBRARY ${HDF5_LIBRARIES})
  endif ()
  set (HDF5_FOUND 1)
  set (HDF5_INCLUDE_DIR_GEN ${HDF5_INCLUDE_DIR_GEN})
  set (HDF5_VERSION_STRING ${HDF5_VERSION_STRING})
  if (WIN32)
    set(CMAKE_TEST_LIB_DIRECTORY "${CMAKE_TEST_LIB_DIRECTORY};${HDF5_TOOLS_DIR}")
  else ()
    set(CMAKE_TEST_LIB_DIRECTORY "${CMAKE_TEST_LIB_DIRECTORY};${HDF5_LIBRARY_PATH}")
  endif ()
endmacro ()
