#
# Copyright by The HDF Group.
# All rights reserved.
#
# This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
# including terms governing use, modification, and redistribution, is
# contained in the COPYING file, which can be found at the root of the
# source code distribution tree. The copyright notice can also be found
# at https://www.hdfgroup.org/licenses.  If you do not have access to
# either file, you may request a copy from help@hdfgroup.org.
#

# This is the CMakeCache file.

########################
# EXTERNAL cache entries
########################

set (BUILD_SHARED_LIBS OFF CACHE BOOL "Build Shared Libraries" FORCE)

set (USE_SHARED_LIBS OFF CACHE BOOL "Use Shared Libraries" FORCE)

set (BUILD_TESTING ON CACHE BOOL "Build H4H5 Unit Testing" FORCE)

set (CMAKE_INSTALL_FRAMEWORK_PREFIX "Library/Frameworks" CACHE STRING "Frameworks installation directory" FORCE)

set (HDF_PACKAGE_EXT "" CACHE STRING "Name of HDF package extension" FORCE)

set (HDF_PACKAGE_NAMESPACE "h4h5::" CACHE STRING "Name for HDF package namespace" FORCE)
set (H4H5_HDF_PACKAGE_NAMESPACE "hdf4::" CACHE STRING "Name for HDF4 package namespace" FORCE)
set (H4H5_HDF5_PACKAGE_NAMESPACE "hdf5::" CACHE STRING "Name for HDF5 package namespace" FORCE)

set (HDF_BUILD_EXAMPLES ON CACHE BOOL "Build H4H5 Library Examples" FORCE)

set (HDF_BUILD_TOOLS ON CACHE BOOL "Build H4H5 Tools" FORCE)

set (HDF_BUILD_UTILS ON CACHE BOOL "Build H4H5 Library Utilities" FORCE)

set (H4H5_ENABLE_EOS2 ON CACHE BOOL "Allow conversions of HDF4-EOS2 files" FORCE)

set (H4H5_TEST_HDFEOS2 OFF CACHE BOOL "Test H4H5 EOS Library Utility" FORCE)

set (HDF_ENABLE_JPEG_LIB_SUPPORT ON CACHE BOOL "Enable Jpeg library" FORCE)

set (HDF_ENABLE_Z_LIB_SUPPORT ON CACHE BOOL "Enable Zlib Filters" FORCE)

set (HDF_ENABLE_SZIP_SUPPORT ON CACHE BOOL "Use SZip Filter" FORCE)

set (HDF_ENABLE_SZIP_ENCODING ON CACHE BOOL "Use SZip Encoding" FORCE)

set (HDF5_USE_16_API_DEFAULT OFF CACHE BOOL "Use the HDF5 1.6.x API" FORCE)

set (HDF_DISABLE_COMPILER_WARNINGS OFF CACHE BOOL "Disable compiler warnings" FORCE)

set (HDF_ENABLE_COVERAGE OFF CACHE BOOL "Enable code coverage for Libraries and Programs" FORCE)

set (HDF_PACKAGE_EXTLIBS OFF CACHE BOOL "(WINDOWS)CPACK - include external libraries" FORCE)

set (HDF_ALLOW_EXTERNAL_SUPPORT "NO" CACHE STRING "Allow External Library Building (NO GIT TGZ)" FORCE)
set_property (CACHE HDF_ALLOW_EXTERNAL_SUPPORT PROPERTY STRINGS NO GIT TGZ)

set (ZLIB_GIT_URL "https://git@bitbucket.hdfgroup.org/scm/test/zlib.git" CACHE STRING "Use ZLIB from HDF repo" FORCE)
set (ZLIB_GIT_BRANCH "master" CACHE STRING "" FORCE)

set (SZIP_GIT_URL "https://git@bitbucket.hdfgroup.org/scm/test/szip.git" CACHE STRING "Use SZIP from HDF repo" FORCE)
set (SZIP_GIT_BRANCH "master" CACHE STRING "" FORCE)

set (JPEG_GIT_URL "https://git@bitbucket.hdfgroup.org/scm/test/jpeg.git" CACHE STRING "Use JPEG from HDF repo" FORCE)
set (JPEG_GIT_BRANCH "jpeg8d" CACHE STRING "" FORCE)

set (HDF4_GIT_URL "https://git@bitbucket.hdfgroup.org/scm/hdffr/hdf4.git" CACHE STRING "Use HDF4 from HDF repo" FORCE)
set (HDF4_GIT_BRANCH "master" CACHE STRING "" FORCE)

set (HDF5_GIT_URL "https://git@bitbucket.hdfgroup.org/scm/hdffv/hdf5.git" CACHE STRING "Use HDF5 from HDF repo" FORCE)
set (HDF5_GIT_BRANCH "develop" CACHE STRING "" FORCE)

set (ZLIB_TGZ_NAME "ZLib.tar.gz" CACHE STRING "Use ZLib from compressed file" FORCE)

set (SZIP_TGZ_NAME "SZip.tar.gz" CACHE STRING "Use SZip from compressed file" FORCE)

set (JPEG_TGZ_NAME "JPEG8d.tar.gz" CACHE STRING "Use JPEG from compressed file" FORCE)

set (HDF4_TGZ_NAME "HDF4.tar.gz" CACHE STRING "Use HDF4 from compressed file" FORCE)

set (HDF5_TGZ_NAME "HDF5.tar.gz" CACHE STRING "Use HDF5 from compressed file" FORCE)

set (HDF4_PACKAGE_NAME "hdf4" CACHE STRING "Name of HDF4 package" FORCE)

set (HDF5_PACKAGE_NAME "hdf5" CACHE STRING "Name of HDF5 package" FORCE)

set (ZLIB_PACKAGE_NAME "zlib" CACHE STRING "Name of ZLIB package" FORCE)

set (SZIP_PACKAGE_NAME "szip" CACHE STRING "Name of SZIP package" FORCE)

set (JPEG_PACKAGE_NAME "jpeg" CACHE STRING "Name of JPEG package" FORCE)
