/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group (THG) and                                     *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the COPYING file, which can be found at the root of the      *
 * source code distribution tree. The copyright notice can also be found     *
 * at https://www.hdfgroup.org/licenses.  If you do not have access to       *
 * either file, you may request a copy from help@hdfgroup.org.               * 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "h4toh5.h"

/*
 *  This example illustrates how to use the libh4toh5.
 *
 *  The input file is 'sds_lib_test.hdf', which has one SDS.
 *
 */


int main() {
  hid_t         h4toh5id; /* libh4toh5 id*/
  int32         sd_id;  /* SD interface id*/
  int32         sds_id; /* SDS interface id*/

  /*
   *  1. initialize libh4toh5
   */
  h4toh5id= H4toH5open("sds_lib_test.hdf","sds_lib_test.h5",H425_CLOBBER);

   /*
    * 2. Open the SD interface and attache to the SDS
    */
  sd_id   = SDstart("sds_lib_test.hdf",DFACC_READ);
  sds_id = SDselect(sd_id,0);

  /*
   *  3. call the libh4toh5 to convert from hdf4 to hdf5.
   */
  H4toH5sds(h4toh5id,sds_id,"/group1",NULL,NULL,1,1);

  /*
   *  4. close HDF4
   */
  SDendaccess(sds_id);
  SDend(sd_id);

  /*
   *  5. close h4toh5 interface.
   */
  H4toH5close(h4toh5id);
}
