/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group and                                           *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the COPYING file, which can be found at the root of the      *
 * source code distribution tree. The full H4H5TOOLS copyright notice can    *
 * also be found at https://www.hdfgroup.org/licenses.  If you do not have   *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains function prototypes for each exported function in
 * the H4TOH5I module.
 */
#ifndef _H4TOH5Ipublic_H
#define _H4TOH5Ipublic_H

/* Public headers needed by this file */
#include "hdf5.h"
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
/*
 * Group values allowed.  Start with `1' instead of `0' because it makes the
 * tracing output look better when hid_t values are large numbers.  Change the
 * GROUP_BITS in H4TOH5I.c if the MAXID gets larger than 32 (an assertion will
 * fail otherwise).
 */
typedef enum {
    H4TOH5I_BADID		= (-1),	/*invalid Group				    */
    H4TOH5I_H4TOH5,
    H4TOH5I_NGROUPS		        /*number of valid groups, MUST BE LAST!	    */
} H4TOH5I_type_t;

/* Type of atoms to return to users */
typedef unsigned int h4toh5_uint;
H4TOH5I_type_t H4TOH5Iget_type(hid_t id);

#endif
