 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the COPYING file, which can be found at the root of the      *
 * source code distribution tree. The full H4H5TOOLS copyright notice can    *
 * also be found at https://www.hdfgroup.org/licenses.  If you do not have   *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
 
#ifndef H4TOH5APICOMPITABLE_H
#define H4TOH5APICOMPITABLE_H

#if (H5_VERS_MAJOR == 1 && H5_VERS_MINOR == 6) || defined H5_USE_16_API

    #define H5GOPEN(fd, name) H5Gopen(fd, name)
    #define H5DOPEN(fd, name) H5Dopen(fd, name)
    #define H5DCREATE(fd, name, tid, sid, did) H5Dcreate(fd, name, tid, sid, did)
    #define H5ACREATE(fd, name, tid, sid, aid) H5Acreate(fd, name, tid, sid, aid)
    #define H5GCREATE(fd, name, hint) H5Gcreate(fd, name, hint)
    #define H5TCOMMIT(fd, name, tid) H5Tcommit(fd, name, tid)
    #define H5TARRAY_CREATE(tid, rank, dims, perm) H5Tarray_create(tid, rank, dims, perm)
    #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference(obj_id,ref_type,ref)

#else 

    #define H5GOPEN(fd, name) H5Gopen2(fd, name, H5P_DEFAULT)
    #define H5DOPEN(fd, name) H5Dopen2(fd, name, H5P_DEFAULT)
    #define H5DCREATE(fd, name, tid, sid, did) H5Dcreate2(fd, name, tid, sid, H5P_DEFAULT, did, H5P_DEFAULT)
    #define H5ACREATE(fd, name, tid, sid, aid) H5Acreate2(fd, name, tid, sid, aid, H5P_DEFAULT)
    #define H5GCREATE(fd, name, hint) H5Gcreate2(fd, name, H5P_DEFAULT, H5P_DEFAULT, H5P_DEFAULT)
    #define H5TCOMMIT(fd, name, tid) H5Tcommit2(fd, name, tid, H5P_DEFAULT, H5P_DEFAULT, H5P_DEFAULT)
    #define H5TARRAY_CREATE(tid, rank, dims, perm) H5Tarray_create2(tid, rank, dims)

    #if (H5_VERS_MAJOR == 1 && H5_VERS_MINOR == 8)
        #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference(obj_id,ref_type,ref)

    #else
        #if (defined H5_USE_18_API)
            #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference1(obj_id,ref_type,ref)
        
        /* Note: in 1.10, H5Rdereference2 is used by default,
           a new parameter opal_id (object access property list) is now added. We may not
           have time to tackle this in this release. So still use H5Rdereference2.
           https://support.hdfgroup.org/HDF5/doc/RM/RM_H5R.html#Reference-Dereference
        */
        #else                                        
            #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference1(obj_id,ref_type,ref)
        #endif
    #endif

    
#endif

#endif

