/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group and                                           *
 * The Board of Trustees of the University of Illinois.                      *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the COPYING file, which can be found at the root of the      *
 * source code distribution tree. The copyright notice can also be found     *
 * at https://www.hdfgroup.org/licenses.  If you do not have access to       *
 * either file, you may request a copy from help@hdfgroup.org.               * 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "h4toh5.h"

/* There are 12 test cases for h4toh5 library.*/
/* h4h5apitestdefault,
     h4h5apitestname,
     h4h5apitestimage,
     h4h5apitestimageattr,
     h4h5apitestsds,
     h4h5apitestsdsattr,
     h4h5apitestvdata,
     h4h5apitestvdataattr,
     h4h5apitestadvgroup,
     h4h5apitestbasvgroup,
     h4h5apitestloneimage,
     h4h5apitestlonesds,
     h4h5apitestlonevdata

     This file is h4h5apitestlonesds:

        will test h4toh5 all lone SDS conversion APIs.
    
*/

/*-------------------------------------------------------------------------
 * Function:    main
 *
 * Purpose:      
 *-------------------------------------------------------------------------
 */ 

 
int main() {

    hid_t                   h4toh5id; /* h4toh5 id*/
    int                     h4toh5status;/* temporary variable to check the status of h4toh5 APIs. */
    
     
    if((h4toh5id= H4toH5open("sds_lib_lonetest.hdf","sds_lib_lonetest.h5",H425_CLOBBER)) < 0) {
        printf("can not start h4toh5 interfaces\n");
        return FAIL;
    }

    if(H4toH5all_lone_sds(h4toh5id,"/",NULL,1,1)<0) {
        printf(" can not convert all independent SDS objects\n");
        H4toH5error_get(h4toh5id);
        H4toH5close(h4toh5id);
        return FAIL;
    }

    h4toh5status = H4toH5close(h4toh5id);
    if(h4toh5status == FAIL) {
        printf("can not close h4toh5 APIs. \n");
        return FAIL;
    }
    return 0;
}


