/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group and                                           *
 * The Board of Trustees of the University of Illinois.                      *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the COPYING file, which can be found at the root of the      *
 * source code distribution tree. The copyright notice can also be found     *
 * at https://www.hdfgroup.org/licenses.  If you do not have access to       *
 * either file, you may request a copy from help@hdfgroup.org.               * 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "h4toh5.h"
/* There are 12 test cases for h4toh5 library.*/
/* h4h5apitestdefault,
     h4h5apitestname,
     h4h5apitestimage,
     h4h5apitestimageattr,
     h4h5apitestsds,
     h4h5apitestsdsattr,
     h4h5apitestvdata,
     h4h5apitestvdataattr,
     h4h5apitestadvgroup,
     h4h5apitestbasvgroup,
     h4h5apitestloneimage,
     h4h5apitestlonesds,
     h4h5apitestlonevdata
     
     This file is h4h5apitestvdata.c
     1) will test different parameter settings for h4toh5vdata.
*/
/*-------------------------------------------------------------------------
 * Function:        main
 *
 * Purpose:         
 *                       
 * Return:  
 
     Modfication: 
 *-------------------------------------------------------------------------
 */ 

 
int main() {

    hid_t                   h4toh5id;/*h4toh5 identifier*/
    int32                   file_id;/* HDF4 file id */
    int32                   vdata_id;/*Vdata id */
    int32                   vdata_ref;/*Vdata reference number */
    int32                   status;/*temporary variable to check status of HDF4 APIs */
    int                     h4toh5status;/*temporary variable to check status of H4toH5 APIs */
     
     /** open H interface **/
    file_id = Hopen("vdata_lib_test.hdf",DFACC_READ,0);
    if(file_id == FAIL) {
        printf("cannot open H interface. \n");
        return FAIL;
    }

    /** open V interface **/
    status  = Vstart(file_id);
    if(status == FAIL) {
        printf("cannot start V interface.\n");
        Hclose(file_id);
        return FAIL;
    }

    if((h4toh5id= H4toH5open("vdata_lib_test.hdf","vdata_lib_test.h5",H425_CLOBBER)) < 0) {
        printf("cannot open H4toH5 library interface\n");
        Vend(file_id);
        Hclose(file_id);
        return FAIL;
    }

    /* Since Vdata may be attributes, in order to avoid converting attributes;
         we use hdp to find the reference number of an independent vdata in this 
         file and obtain vdata id later. */
    vdata_ref = 2;
    vdata_id = VSattach(file_id,vdata_ref,"r");
    if(vdata_id == FAIL) {
        printf("cannot obtain vdata id.\n");
        Vend(file_id);
        Hclose(file_id);
        return FAIL;
    }

    /* vdata conversion. */
    if(H4toH5vdata(h4toh5id,vdata_id,"/group1",NULL,0)<0) {
        printf("Vdata conversion test failed\n");
        H4toH5error_get(h4toh5id);
        VSdetach(vdata_id);
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }

    /* vdata attribute conversion by index. */
    if(H4toH5vdata_attr_index(h4toh5id,vdata_id,"/group1",NULL,1)<0){
        printf("Vdata attribute(by index) conversion test failed\n");
        H4toH5error_get(h4toh5id);
        VSdetach(vdata_id);
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }

    /* vdata field attribute conversion by index. */
    if(H4toH5vdata_field_attr_index(h4toh5id,vdata_id,"/group1",NULL,2,2)<0){
        printf("Vdata field attribute(by index) conversion test failed\n");
        H4toH5error_get(h4toh5id);
        VSdetach(vdata_id);
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }

    /* close all interfaces. */
    status = VSdetach(vdata_id);
    if(status == FAIL) {
        printf("cannot detach Vdata \n");
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }
    status = Vend(file_id);
    if(status == FAIL) {
        printf("cannot end V interface. \n");
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }
    status = Hclose(file_id);
    if(status == FAIL) {
        printf("cannot close H interface. \n");
        H4toH5close(h4toh5id);
        return FAIL;
    }
    h4toh5status = H4toH5close(h4toh5id);
    if(h4toh5status == FAIL){
        printf("cannot close h4toh5 interface. \n");
        return FAIL;
    }

    return 0;
}
