/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group and                                           *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the COPYING file, which can be found at the root of the      *
 * source code distribution tree. The full H4H5TOOLS copyright notice can    *
 * also be found at https://www.hdfgroup.org/licenses.  If you do not have   *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/******************************************************************************

Description:

1. converter

See HDF4 to HDF5 mapping specification at
(https://support.hdfgroup.org/products/hdf5_tools/h4toh5/) for the default mapping
from HDF4 object to HDF5 object.

The whole converter includes 10 files, h4toh5util.h, h4toh5main.h, h4toh5util.c, h4toh5main.c, h4toh5sds.c, h4toh5image.c,h4toh5vdata.c,h4toh5vgroup.c,h4toh5pal.c and h4toh5anno.c.

2. this file

including declarations of subroutines of all .c files excluding h4toh5util.c.

Author:  Kent Yang(myang6@hdfgroup.org)


*****************************************************************************/


#ifndef H4TOH5MAIN_H
#define H4TOH5MAIN_H
#include "hdf.h"
#include "mfhdf.h"
#ifdef HAVE_LIBHDFEOS
#include "HdfEosDef.h"
#endif
#include "hfile.h"
#include "hdf5.h"
#include <fcntl.h>
#include <sys/types.h>
#ifndef WIN32
#include <unistd.h>
#endif

/* For windows support.*/
#ifdef WIN32
typedef unsigned int mode_t;
#endif

#ifndef S_ISDIR
#define S_ISDIR(mode) (((mode)&0xF000) == S_IFDIR)
#endif

/* subroutines to check initial settings and inputting parameters.
Adapted from h5toh4 tools and used for h4toh5main.c */

void PrintOptions_h4toh5(int version_info);
int util_test_file(char *filename,int oflag,mode_t mode);
int util_test_dir(char *);
int h4toh5(char*,char*,int);
#ifdef HAVE_LIBHDFEOS
int h4eos2toh5(char*,char*);
#endif
int gen_h4toh5(char*,char*,int);
char *util_BuildFilename(char *filename, char *ext);

/* subroutines for h4toh5main.c */
int h4toh5lonevgs(hid_t,int32,int);
int h4toh5vgrings(hid_t,int32,int);

/* routine for zeroing out the memory. */
void util_h4toh5_ZeroMemory(void*s,size_t n);
#endif








