#!/bin/sh
#
# Copyright by The HDF Group. 
# All rights reserved.
#
# This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
# including terms governing use, modification, and redistribution, is
# contained in the COPYING file, which can be found at the root of the
# source code distribution tree. The copyright notice can also be found
# at https://www.hdfgroup.org/licenses.  If you do not have access to
# either file, you may request a copy from help@hdfgroup.org.
#

if [ -z "$NCDUMP" ]; then
    echo Environment variable NCDUMP should be set.
    exit
fi

H4TOH5=h4toh5
H4TOH5_BIN=`pwd`/$H4TOH5
RM="rm -rf"

SRCDIR="../testfiles"
OUTDIR="../testfiles/Results"

test -d "$OUTDIR" || mkdir $OUTDIR

nerrors=0

TESTING() {
  SPACES="                                                                                   "
  echo "Testing $* $SPACES" |cut -c1-80 |tr -d '\012'
}

SKIP() {
  TESTING $H4TOH5 $@

  echo " -SKIP-"
}

CONVERT() {
    INFILES=""
    OUTFILES=""
    H4TOH5OPT=""

    case "$1" in
    -e)
        TESTING $H4TOH5 $@
        OUTPATH=`dirname $2`

        if test "$SRCDIR" != "$OUTDIR"; then
            test -d "$OUTDIR/$OUTPATH" || mkdir $OUTDIR/$OUTPATH
            cp $SRCDIR/$2 $OUTDIR/$2
        fi
        INFILES="$2"
        OUTFILES="$3"
        H4TOH5OPT="-eos -nc4 -nc4strict"

        curdir=`pwd`
        {
            cd $OUTDIR
            if $H4TOH5_BIN $H4TOH5OPT $INFILES $OUTFILES 2>/dev/null; then
                if $NCDUMP $OUTFILES 2>/dev/null; then
                    echo "PASSED"
                else
                    echo "*FAILED* (ncdump)"
                    nerrors="`expr $nerrors + 1`"
                fi
            else
                echo "*FAILED* (h4toh5)"
                nerrors="`expr $nerrors + 1`"
            fi
            if test "$SRCDIR" != "$OUTDIR"; then
                $RM $INFILES
            fi
        }
        cd $curdir
        ;;
    -f)
        SKIP $H4TOH5 $@
        ;;
    esac
}

# the following can be copied from gen_expected.sh

CONVERT -e grid/grid_geo_xy.hdf grid/grid_geo_xy.h5
CONVERT -e grid/grid_geo_yx.hdf grid/grid_geo_yx.h5
CONVERT -e grid/grid_geo_timexy.hdf grid/grid_geo_timexy.h5
CONVERT -e grid/grid_geo_timeyx.hdf grid/grid_geo_timeyx.h5
CONVERT -e grid/grid_utm_xy.hdf grid/grid_utm_xy.h5
CONVERT -e grid/grid_utm_yx.hdf grid/grid_utm_yx.h5
CONVERT -e grid/grid_utm_timexy.hdf grid/grid_utm_timexy.h5
CONVERT -e grid/grid_utm_timeyx.hdf grid/grid_utm_timeyx.h5
CONVERT -e grid/grid_geo_xyxy.hdf grid/grid_geo_xyxy.h5
CONVERT -e grid/grid_geo_yxyx.hdf grid/grid_geo_yxyx.h5
CONVERT -f grid/grid_geo_xyyx.hdf grid/grid_geo_xyyx.h5
CONVERT -f grid/grid_geo_nil.hdf grid/grid_geo_nil.h5
CONVERT -e grid/grid_utm_xyxy.hdf grid/grid_utm_xyxy.h5
CONVERT -e grid/grid_utm_yxyx.hdf grid/grid_utm_yxyx.h5
CONVERT -f grid/grid_utm_xyyx.hdf grid/grid_utm_xyyx.h5
CONVERT -f grid/grid_utm_nil.hdf grid/grid_utm_nil.h5

CONVERT -e swath/swath_basic.hdf swath/swath_basic.h5
CONVERT -e swath/swath_0101.hdf swath/swath_0101.h5
CONVERT -e swath/swath_1111.hdf swath/swath_1111.h5
CONVERT -e swath/swath_2121.hdf swath/swath_2121.h5
CONVERT -e swath/swath_n11n11.hdf swath/swath_n11n11.h5
CONVERT -e swath/swath_n11n11_tight.hdf swath/swath_n11n11_tight.h5
CONVERT -e swath/swath_n21n21.hdf swath/swath_n21n21.h5
CONVERT -e swath/swath_0202.hdf swath/swath_0202.h5
CONVERT -e swath/swath_1212.hdf swath/swath_1212.h5
CONVERT -e swath/swath_2222.hdf swath/swath_2222.h5
CONVERT -e swath/swath_n12n12.hdf swath/swath_n12n12.h5
CONVERT -e swath/swath_n22n22.hdf swath/swath_n22n22.h5
CONVERT -e swath/swath_0n20n2.hdf swath/swath_0n20n2.h5
CONVERT -e swath/swath_1n21n2.hdf swath/swath_1n21n2.h5
CONVERT -e swath/swath_2n22n2.hdf swath/swath_2n22n2.h5
CONVERT -e swath/swath_n1n2n1n2.hdf swath/swath_n1n2n1n2.h5
CONVERT -e swath/swath_n2n2n2n2.hdf swath/swath_n2n2n2n2.h5
CONVERT -e swath/swath_qdd.hdf swath/swath_qdd.h5
CONVERT -e swath/swath_dqd.hdf swath/swath_dqd.h5
CONVERT -e swath/swath_ddq.hdf swath/swath_ddq.h5
CONVERT -e swath/swath_qgg.hdf swath/swath_qgg.h5
CONVERT -e swath/swath_gqg.hdf swath/swath_gqg.h5
CONVERT -e swath/swath_ggq.hdf swath/swath_ggq.h5
CONVERT -e swath/swath_tll.hdf swath/swath_tll.h5
CONVERT -e swath/swath_tll02.hdf swath/swath_tll02.h5

if test $nerrors -eq 0 ; then
  echo "All h4toh5 tests passed."
fi

$RM -r $OUTDIR
exit $nerrors

# vim:ts=8:sts=4:sw=4:et
