/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group and                                           *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the COPYING file, which can be found at the root of the      *
 * source code distribution tree. The full H4H5TOOLS copyright notice can    *
 * also be found at https://www.hdfgroup.org/licenses.  If you do not have   *
 * access to either file, you may request a copy from help@hdfgroup.org.     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 *
 * Programmer:  Paul Harten <pharten@ncsa.uiuc.edu>
 *              Friday, October 16th, 1998
 *
 * Purpose:	Convert H5 files to H4 files.
 */

#ifndef _H5TOH4_H
#define _H5TOH4_H

#include "mfhdf.h"
#include "hdf5.h"

#include "h5toh4apicompatible.h"

#ifdef H5_HAVE_SYS_STAT_H
#   include <sys/stat.h>
#endif

typedef struct op_data_t {
    /*
     * information being carried between iterations.
     *
     */

    int32 hfile_id;
    int32 vgroup_id;
    int32 sd_id;
    int32 sds_id;
    int32 vdata_id;
    int32 obj_idx;
    int32 gr_id;
    int32 grimage_id;
    int32 an_id;
} op_data_t;

#ifdef H5TOH4_DEBUG
#define DEBUG_PRINT(s1,s2,s3,n1) ( fprintf(stderr,s1,s2,s3,n1) )
#else
#define DEBUG_PRINT(s1,s2,s3,n1) ( fprintf(stderr," ") )
#endif
/* Remove this later. 9/27/2007
#if H5_VERS_MAJOR==1 && H5_VERS_MINOR<8
#define H5Gopen_abs(S,F) H5Gopen(S,F)
#define H5Eset_auto_abs(S,F) H5Eset_auto(S,F)
#define H5Eget_auto_abs(S,F) H5Eget_auto(S,F)
#else
#define H5Gopen_abs(S,F) H5Gopen(S,F,H5P_DEFAULT)
#define H5Eset_auto_abs(S,F) H5Eset_auto(H5E_DEFAULT,S,F)
#define H5Eget_auto_abs(S,F) H5Eget_auto(H5E_DEFAULT,S,F)
#endif
*/


#endif
