/*! @file
 *
 * Meta information for libccr which can be used by other packages which
 * depend on libccr.
 *
 * @author Ed Hartnett
 * @date 12/10/2020
 */

#ifndef CCR_META_H
#define CCR_META_H

#define CCR_VERSION_MAJOR 1 /*!< CCR major version. */
#define CCR_VERSION_MINOR 3 /*!< CCR minor version. */
#define CCR_VERSION_PATCH 0 /*!< CCR patch version. */
#define CCR_VERSION_NOTE  "" /*!< CCR note. May be blank. */
#define CCR_VERSION       "1.3.0" /*!< CCR version string. */

#define CCR_HAS_BZIP2          1 /*!< BZIP2 support. */
#define CCR_HAS_ZSTD           1 /*!< ZSTD support. */
#define CCR_HAS_LZ4            0 /*!< LZ4 support. */
#define CCR_HAS_BITGROOM       1 /*!< BITGROOM support. */
#define CCR_HAS_NETCDF_PAR     0 /*!< Parallel I/O support. */
#define CCR_HAS_PAR_FILTERS    1 /*!< Parallel I/O filter support. */
#define CCR_HAS_MULTIFILTERS   1 /*!< Multiple filter support. */
#define CCR_HAS_BENCHMARKS     0 /*!< Benchmarks built. */
#define CCR_HAS_FORTRAN        0 /*!< Benchmarks built. */

#endif
